% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox_res.R
\name{plot_cox_res}
\alias{plot_cox_res}
\title{Plot Cox Regression Results}
\usage{
plot_cox_res(cox.res.df, x.lab, y.lab, y.col = "term", color.col,
  color.legend.name, coord.flip = FALSE, facet.formula = NULL,
  facet.scales = "fixed", add_sig_line = TRUE)
}
\arguments{
\item{cox.res.df}{data.frame output from \code{get_cox_res}.}

\item{x.lab}{x-axis label.}

\item{y.lab}{y-axis label.}

\item{y.col}{Column name that contains the values for the y-values.}

\item{color.col}{Column name that contains color groups.}

\item{color.legend.name}{Title for the color legend.}

\item{coord.flip}{By default hazard ratio and its confidence interval is 
plotted on the y-axis using ggplot2::geom_errorbarh(). If this is set to
TRUE, then this information is plotted along the x-axis using 
ggplot2::geom_errorbar(). This means that the x.lab and y.lab will be 
flipped to.}

\item{facet.formula}{Facet formula for faceting the plot. This should be
used plotting results from \code{iter_get_cox_res} or when the parameter 
group is used in \code{get_cox_res} and \code{iter_get_cox_res}.}

\item{facet.scales}{Parameter passed to the scales parameter in 
\code{ggplot2::facet_grid}.}

\item{add_sig_line}{Boolean to indicate if a red, dotted, vertical line 
should be added to allow users to see if a Cox regression confidence 
interval overlaps with 1.}
}
\value{
Forest plot of cox regression results in the ggplot framework.
}
\description{
\code{plot_cox_res} takes the output from \code{get_cox_res} and generates
a forest plot showing the hazard ratio and confidence interval of the cox
cox regression.
}
\examples{
\dontrun{
library("survival")
library("magrittr")
library("dplyr")

in.df <- colon
endpoint <- "time"
endpoint.code <- "status"

# Run and Plot Multivariate Cox Regression on Entire data.frame
features <- c("age", "obstruct")
cox.res.df <- get_cox_res(colon, endpoint, endpoint.code, features)
plot_cox_res(cox.res.df)

# Run and Plot Multivariate Cox Regression For Each rx Group
group <- "rx"
cox.res.df <- get_cox_res(colon, endpoint, endpoint.code, features, group)
plot_cox_res(cox.res.df, facet.formula = ". ~ group")

# Change x and y labels
plot_cox_res(cox.res.df, facet.formula = ". ~ group", 
             x.lab = "Hazard Ratio", y.lab = "Feature")

# Adding colors
cox.res.df \%>\%
  mutate(sig_flag = p.value < 0.05) \%>\%
  plot_cox_res(facet.formula = ". ~ group", x.lab = "Hazard Ratio", 
               y.lab = "Feature", 
               color.col = "sig_flag", 
               color.legend.name = "Significant Flag")

# Flipping Plot
cox.res.df \%>\%
  mutate(sig_flag = p.value < 0.05) \%>\%
  plot_cox_res(facet.formula = ". ~ group", x.lab = "Hazard Ratio", 
               y.lab = "Feature", 
               color.col = "sig_flag", 
               color.legend.name = "Significant Flag", 
               coord.flip = TRUE)
}
}
