% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_functions.R
\name{skislopes}
\alias{skislopes}
\title{Convenience function for skislope color scheme}
\usage{
skislopes(g, reverse = FALSE)
}
\arguments{
\item{g}{ggplot object containing a Kaplan-Meier plot}

\item{reverse}{should the order of the colors be reversed?}
}
\value{
Returns a ggplot object
}
\description{
Convenience function to change the color scheme to
four colors: Green, blue, red, and black; i.e.
as ski slopes are classified.
}
\examples{
\dontrun{
library(survival)
library(dplyr)
veteran \%>\%
    survfit(Surv(time, status) ~ celltype, data = .) \%>\%
   plot_survfit(cuminc = FALSE) \%>\%
   skislopes(reverse = TRUE)
}
}
\author{
Daniel Lindholm
}
