% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcoxadjustedcurves.R
\name{ggcoxadjustedcurves}
\alias{ggcoxadjustedcurves}
\title{Adjusted Survival Curves for Cox Proportional Hazards Model}
\usage{
ggcoxadjustedcurves(fit, variable = NULL, individual.curves = FALSE,
  data = NULL, fun = NULL, palette = "hue", curve.size = 2,
  curve.alpha = 0.2, ylab = "Survival rate", ggtheme = theme_survminer(),
  ...)
}
\arguments{
\item{fit}{an object of class \link{coxph.object} - created with \link{coxph} function.}

\item{variable}{a variable (vector) with values corresponding to groups to be plotted}

\item{individual.curves}{if TRUE then all individual predicted survival curves will be plotted}

\item{data}{a dataset for predictions. If not supplied then data will be extracted from `fit` object.}

\item{fun}{an arbitrary function defining a transformation of the survival
curve.  Often used transformations can be specified with a character
argument: "event" plots cumulative events (f(y) = 1-y), "cumhaz" plots the
cumulative hazard function (f(y) = -log(y)), and "pct" for survival
probability in percentage.}

\item{palette}{the color palette to be used. Allowed values include "hue" for
the default hue color scale; "grey" for grey color palettes; brewer palettes
e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red").
See details section for more information.  Can be also a numeric vector of
length(groups); in this case a basic color palette is created using the
function \link[grDevices]{palette}.}

\item{curve.size, curve.alpha}{size and alpha for individual survival curves}

\item{ylab}{y axis label.}

\item{ggtheme}{function, ggplot2 theme name.
Allowed values include ggplot2 official themes: see \code{\link[ggplot2]{theme}}.}

\item{...}{further arguments passed to the function \code{\link[ggpubr]{ggpar}} for customizing the plot.}
}
\value{
Returns an object of class \code{gg}.
}
\description{
This function plots adjusted survival curves for coxph model.
The idea behind this function is described in \code{https://cran.r-project.org/web/packages/survival/vignettes/adjcurve.pdf}.
For every observation in the dataset a prediction for survival curve is made.
Then the predictions are averaged with respect to a selected variable.
}
\examples{

library(survival)
fit2 <- coxph( Surv(stop, event) ~ rx + size, data = bladder )
ggcoxadjustedcurves(fit2, data = bladder)
ggcoxadjustedcurves(fit2, individual.curves = TRUE, data = bladder, curve.alpha=0.01)
ggcoxadjustedcurves(fit2, data = bladder, variable= bladder[,"rx"])
ggcoxadjustedcurves(fit2, data = bladder, variable= bladder[,"rx"],
   individual.curves=TRUE, curve.alpha=0.01)

}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
