% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{challenge_results}
\alias{challenge_results}
\title{Challenge Results}
\format{
This nested data frame contains the following columns:
\describe{
  \item{\code{season_name}}{The season name}
  \item{\code{season}}{The season number}
  \item{\code{episode}}{Episode number}
  \item{\code{day}}{The day of the tribal council}
  \item{\code{order}}{The number of boots that there have been in the game e.g. if `order == 2` there have been 2
  boots in the game so far and there are N-2 castaways left in the game}
  \item{\code{episode_title}}{Episode title}
  \item{\code{challenge_name}}{The name of the challenge. Challenges can go by different names but where possible
  recurring challenges are kept consistent. While there are tweaks to the challenges where the main components of
  the challenge consistent they share the same name}
  \item{\code{challenge_type}}{The challenge type e.g. immunity, reward, etc}
  \item{\code{outcome_type}}{Whether the challenge is individual or tribal. Some individual reward challenges may involve multiple castawats as the winner gets to choose who they bring along}
  \item{\code{challenge_id}}{Primary key to the \code{challenge_description} data set which contains features of the challenge}
  \item{\code{winning_tribe}}{Name of the winner tribe. \code{NA} during the merge}
  \item{\code{outcome_status}}{Identifies the winner of individual reward challenges and those chosen to participate
  i.e. they didn't win but were chosen by the winner to join them on the reward.}
  \item{\code{winner}}{The list of winners. Either the list of people in the tribe which won, list of people that participated on the reward or the individual winner}
  \item{\code{winner_id}}{The ID of the winners of the challenge. Consistent with \code{castaway_id}}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Survivor_(American_TV_series)}
}
\usage{
challenge_results
}
\description{
A dataset detailing the challenges played including reward and immunity challenges.
\code{immunity} and \code{rewards} datasets.
}
\details{
A nested tidy data frame of immunity and reward challenge results. The
winners and winning tribe of the challenge are found by expanding the \code{winner}
column. For individual immunity challenges the winning tribe is simply \code{NA}.

Typically in the merge if a single person win a reward they are allowed to bring
others along with them. The first castaway in the expanded list is likely to be the
winner and the subsequent players those they brought along with them. Although,
not always. Occasionally in the merge the castaways are split into two teams for
the purpose of the reward, in which case all castaways win the reward rather than
a single person.

The \code{day} field on this data set represents the day of the tribal council rather
than the day of the challenge. This is to more easily associate the reward challenge
with the immunity challenge and result of the tribal council. It also helps for
joining tables.
}
\examples{
library(dplyr)
library(tidyr)
challenge_results \%>\%
  filter(season == 40) \%>\%
  unnest(winners)
}
\keyword{datasets}
