% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_pycox.R
\name{pycox_prepare_train_data}
\alias{pycox_prepare_train_data}
\title{Prepare Data for Pycox Model Training}
\usage{
pycox_prepare_train_data(
  x_train,
  y_train,
  frac = 0,
  standardize_time = FALSE,
  log_duration = FALSE,
  with_mean = TRUE,
  with_std = TRUE,
  discretise = FALSE,
  cuts = 10L,
  cutpoints = NULL,
  scheme = c("equidistant", "quantiles"),
  cut_min = 0L,
  model = c("coxtime", "deepsurv", "deephit", "loghaz", "pchazard")
)
}
\arguments{
\item{x_train}{\code{(matrix(1))} \cr Training covariates.}

\item{y_train}{\code{(matrix(1))} \cr Training outcomes.}

\item{frac}{\code{(numeric(1))}\cr Fraction of data to use for validation
dataset, default is \code{0} and therefore no separate validation dataset.}

\item{standardize_time}{\code{(logical(1))}\cr If \code{TRUE}, the time outcome to be
standardized. For use with \link{coxtime}.}

\item{log_duration}{\code{(logical(1))}\cr If \code{TRUE} and \code{standardize_time} is
\code{TRUE} then time variable is log transformed.}

\item{with_mean}{\code{(logical(1))}\cr If \code{TRUE} (default) and
\code{standardize_time} is \code{TRUE} then time
variable is centered.}

\item{with_std}{\code{(logical(1))}\cr If \code{TRUE} (default) and \code{standardize_time}
is \code{TRUE} then time
variable is scaled to unit variance.}

\item{discretise}{\code{(logical(1))}\cr If \code{TRUE} then time is discretised. For
use with the models
\link{deephit}, \link{pchazard}, and \link{loghaz}.}

\item{cuts}{\code{(integer(1))}\cr If \code{discretise} is \code{TRUE} then determines
number of cut-points for discretisation.}

\item{cutpoints}{\code{(numeric())} \cr Alternative to \code{cuts} if \code{discretise} is
true, provide exact cutpoints for discretisation. \code{cuts} is ignored if
\code{cutpoints} is non-NULL.}

\item{scheme}{\code{(character(1))}\cr Method of discretisation, either
\code{"equidistant"} (default) or \code{"quantiles"}. See
\code{reticulate::py_help(pycox$models$LogisticHazard$label_transform)}.}

\item{cut_min}{\code{(integer(1))}\cr Starting duration for discretisation, see
\code{reticulate::py_help(pycox$models$LogisticHazard$label_transform)}.}

\item{model}{\code{(character(1))}\cr Corresponding pycox model.}
}
\description{
Utility function to prepare data for training in a Pycox model.
Generally used internally only.
}
