% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_keras.R
\name{get_keras_optimizer}
\alias{get_keras_optimizer}
\title{Get Keras Optimizer}
\usage{
get_keras_optimizer(
  optimizer = "adam",
  lr = 0.02,
  beta_1 = 0.9,
  beta_2 = 0.999,
  epsilon = NULL,
  decay = 0,
  clipnorm = NULL,
  clipvalue = NULL,
  schedule_decay = 0.004,
  momentum = 0,
  nesterov = FALSE
)
}
\arguments{
\item{optimizer}{\code{(character(1))} \cr Optimizer to construct, see details for those available.
Default is \code{"adam"}.}

\item{lr}{\code{(numeric(1))} \cr Passed to all optimizers except \code{adadelta} and \code{adagrad}.}

\item{beta_1, beta_2, epsilon}{\code{(numeric(1))} \cr Passed to \code{adamax}, \code{adam}, and \code{nadam}.}

\item{decay}{\code{(numeric(1))} \cr Passed to \code{adamax}, \code{adam}, and \code{sgd}.}

\item{clipnorm, clipvalue}{\code{(numeric(1))} \cr Passed to \code{adamax}, \code{adam}, \code{nadam}, and \code{sgd}.}

\item{schedule_decay}{\code{(numeric(1))} \cr Passed to \code{nadam}.}

\item{momentum}{\code{(numeric(1))} \cr Passed to \code{sgd}.}

\item{nesterov}{\code{(logical(1))} \cr Passed to \code{sgd}.}
}
\description{
Utility function to construct optimiser from \CRANpkg{keras}, primarily for
internal use.
}
\details{
Implemented optimizers are
\itemize{
\item \code{"adadelta"} \cr \link[keras:optimizer_adadelta]{keras::optimizer_adadelta}
\item \code{"adagrad"} \cr \link[keras:optimizer_adagrad]{keras::optimizer_adagrad}
\item \code{"adamax"} \cr \link[keras:optimizer_adamax]{keras::optimizer_adamax}
\item \code{"adam"} \cr \link[keras:optimizer_adam]{keras::optimizer_adam}
\item \code{"nadam"} \cr \link[keras:optimizer_nadam]{keras::optimizer_nadam}
\item \code{"rmsprop"} \cr \link[keras:optimizer_rmsprop]{keras::optimizer_rmsprop}
\item \code{"sgd"} \cr \link[keras:optimizer_sgd]{keras::optimizer_sgd}
}
}
\examples{
\donttest{
if (requireNamespaces("keras")) {
  get_keras_optimizer()

  get_keras_optimizer(optimizer = "adamax", decay = 0.1, lr = 0.01)
}
}

}
