% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allHR.R
\name{allHR}
\alias{allHR}
\title{For all possible separation points for a cohort ordered by a continuous
measurement, calculate hazard ratio}
\usage{
allHR(measure, srv, time = "Time", event = "Event", log2HR = TRUE,
  remove_outliers = TRUE)
}
\arguments{
\item{measure}{A continuous variable used to order survival data. Samples
must be ordered exactly as in srv}

\item{srv}{A dataframe that contains at least two columns, detailing event 
and time to event information. 
Samples must be ordered exactly as in measure}

\item{time}{Column name in srv containing time to event information. Must 
not contain NAs}

\item{event}{Column name in srv containing event information coded as 0 (no
event) and 1 (event). Must not contain NAs}

\item{log2HR}{Hazard ratios are returned as log2 values by default}

\item{remove_outliers}{Large hazard ratios result from statistical 
disproportion when considering edge cases (e.g. 1 vs 99) and can be 
automaticall removed}
}
\value{
A vector of hazard ratios calculated from \code{srv} ordered by 
\code{measure}
}
\description{
For all possible separation points for a cohort ordered by a continuous
measurement, calculate hazard ratio
}
\examples{
library(survivALL)
data(nki_subset)
library(Biobase)
gene_vec <- exprs(nki_subset)["NM_004448", ] #ERBB2 gene id
allHR(measure = gene_vec, srv = pData(nki_subset), time = "t.dmfs", 
    event = "e.dmfs", log2HR = TRUE)
}
