% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_survey.R
\name{set_survey}
\alias{set_survey}
\title{Specify the survey to analyze}
\usage{
set_survey(design, csv = getOption("surveytable.csv"), ...)
}
\arguments{
\item{design}{a survey object, created with \code{\link[survey:svydesign]{survey::svydesign()}} or
\code{\link[survey:svrepdesign]{survey::svrepdesign()}}. For an unweighted survey, a \code{data.frame} or similar.}

\item{csv}{name of a CSV file}

\item{...}{arguments to \code{\link[=set_opts]{set_opts()}}.}
}
\value{
info about the survey
}
\description{
You must specify a survey before the other functions, such as \code{\link[=tab]{tab()}},
will work. To convert a \code{data.frame} or similar to a survey object, see \code{\link[survey:svydesign]{survey::svydesign()}}
or \code{\link[survey:svrepdesign]{survey::svrepdesign()}}.
}
\details{
Optionally, the survey can have an attribute called \code{label}, which is the
long name of the survey. Optionally, each variable in the survey can have an
attribute called \code{label}, which is the variable's long name.
}
\examples{
set_survey(namcs2019sv)
set_survey(namcs2019sv, mode = "general")
}
\seealso{
Other options: 
\code{\link{set_opts}()},
\code{\link{show_options}()},
\code{\link{surveytable-options}}
}
\concept{options}
