% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{sd_show_if}
\alias{sd_show_if}
\title{Define show conditions for survey questions and pages}
\usage{
sd_show_if(...)
}
\arguments{
\item{...}{One or more formulas defining show conditions.
The left-hand side of each formula should be a condition based on input values,
and the right-hand side should be the ID of the question or page to show if the condition is met.}
}
\value{
A list of parsed conditions, where each element contains the condition and the target question or page ID.
Returns \code{NULL} if no conditions are provided.
}
\description{
This function is used to define conditions under which certain questions or pages in the survey should be shown.
It takes one or more formulas where the left-hand side is the condition and the right-hand side is the target question ID or page ID.
If called with no arguments, it will return \code{NULL} and set no conditions.
}
\examples{
if (interactive()) {
  library(surveydown)

  # Get path to example survey file
  survey_path <- system.file("examples", "sd_show_if.qmd",
                             package = "surveydown")

  # Copy to a temporary directory
  temp_dir <- tempdir()
  file.copy(survey_path, file.path(temp_dir, "survey.qmd"))
  orig_dir <- getwd()
  setwd(temp_dir)

  # Define a minimal server
  server <- function(input, output, session) {

    sd_show_if(
      # If "Other" is chosen, show the conditional question
      input$fav_fruit == "other" ~ "fav_fruit_other",
      # If condition is met, show specific page
      input$category == "advanced" ~ "advanced_page"
    )

    sd_server()
  }

  # Run the app
  shiny::shinyApp(ui = sd_ui(), server = server)

  # Clean up
  setwd(orig_dir)
}

}
\seealso{
\code{sd_skip_forward()}
}
