% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{loss_one_minus_cd_auc}
\alias{loss_one_minus_cd_auc}
\title{Calculate Cumulative/Dynamic AUC loss}
\usage{
loss_one_minus_cd_auc(y_true = NULL, risk = NULL, surv = NULL, times = NULL)
}
\arguments{
\item{y_true}{a \code{survival::Surv} object containing the times and statuses of observations for which the metric will be evaluated}

\item{risk}{ignored, left for compatibility with other metrics}

\item{surv}{a matrix containing the predicted survival functions for the considered observations, each row represents a single observation, whereas each column one time point}

\item{times}{a vector of time points at which the survival function was evaluated}
}
\value{
a numeric vector of length equal to the length of the times vector, each value (from the range from 0 to 1) represents 1 - AUC metric at a specific time point, with lower values indicating better performance.
}
\description{
This function subtracts the C/D AUC metric from one to obtain a loss function whose lower values indicate better model performance (useful for permutational feature importance)
}
\examples{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
cph_exp <- explain(cph)

y <- cph_exp$y
times <- cph_exp$times
surv <- cph_exp$predict_survival_function(cph, cph_exp$data, times)

loss_one_minus_cd_auc(y, surv = surv, times = times)

}
\seealso{
\code{\link[=cd_auc]{cd_auc()}}
}
