% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{waic}
\alias{waic}
\title{Widely Applicable Information Criteria}
\source{
Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation and widely application information criterion in singular learning theory. Journal of Machine Learning Research 11, 3571-3594.
}
\usage{
waic(fit, pointwise = FALSE, digits = 2)
}
\arguments{
\item{fit}{An \code{surveil} object}

\item{pointwise}{Logical (defaults to \code{FALSE}); if \code{pointwise = TRUE}, a vector of values for each observation will be returned.}

\item{digits}{Round results to this many digits.}
}
\value{
A vector of length 3 with \code{WAIC}, a rough measure of the effective number of parameters estimated by the model \code{Eff_pars}, and log predictive density \code{Lpd}. If \code{pointwise = TRUE}, results are returned in a \code{data.frame}.
}
\description{
Widely Application Information Criteria (WAIC) for model comparison
}
\examples{

data(msa)
austin <- msa[grep("Austin", msa$MSA), ]
austin.w <- austin[grep("White", austin$Race),]
fit <- stan_rw(austin.w, time = Year,
               chains = 2, iter = 1200) # for speed only
waic(fit)
 
}
