% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survSRF_ens.R
\name{survsrfens_train}
\alias{survsrfens_train}
\title{Fits an ensemble of Cox-PH and Survival Random Forest (SRF)
with internal CV to tune SRF hyperparameters.}
\usage{
survsrfens_train(
  df_train,
  predict.factors,
  fixed_time = NaN,
  inner_cv = 3,
  randomseed = NaN,
  tuningparams = list(),
  useCoxLasso = FALSE,
  max_grid_size = 10,
  var_importance_calc = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{df_train}{data, "time" and "event" should describe survival outcome}

\item{predict.factors}{list of predictor names}

\item{fixed_time}{time at which performance is maximized}

\item{inner_cv}{number of cross-validation folds for hyperparameters' tuning}

\item{randomseed}{random seed to control tuning including data splits}

\item{tuningparams}{if given, list of hyperparameters, list(mtry=c(), nodedepth=c(),nodesize=c()), otherwise a wide default grid is used}

\item{useCoxLasso}{if CoxLasso is used (TRUE) or not (FALSE, default)}

\item{max_grid_size}{number of random grid searches for model tuning}

\item{var_importance_calc}{if variable importance is computed}

\item{verbose}{FALSE (default)/TRUE}
}
\value{
trained object of class survsrf_ens
}
\description{
Details: the function trains Cox model, then adds its out-of-the-box
predictions to Survival Random Forest as an additional predictor
to mimic stacking procedure used in Machine Learning and reduce over-fitting.
#' Cox model is fitted to .9 data to predict the rest .1 for each 1/10s fold;
these out-of-the-bag predictions are passed on to SRF
}
