% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{surv_validate}
\alias{surv_validate}
\title{Computes performance statistics for a survival data given the predicted event probabilities}
\usage{
surv_validate(
  y_predict,
  predict_time,
  df_train,
  df_test,
  weighted = TRUE,
  alpha = "logit"
)
}
\arguments{
\item{y_predict}{probabilities of event by predict_time (matrix=observations x times)}

\item{predict_time}{times for which event probabilities are given}

\item{df_train}{train data, data frame}

\item{df_test}{test data, data frame}

\item{weighted}{TRUE/FALSE, for IPWC}

\item{alpha}{calibration alpha as mean difference in probabilities, or in log-odds (from logistic regression, default)}
}
\value{
data.frame(T, AUCROC, Brier Score, Scaled Brier Score, C_score, Calib slope, Calib alpha)
}
\description{
Computes performance statistics for a survival data given the predicted event probabilities
}
