% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_crossterms}
\alias{simulate_crossterms}
\title{Simulated sample with survival outcomes with non-linear and cross-term dependencies}
\usage{
simulate_crossterms(
  N = 300,
  observe_time = 10,
  percentcensored = 0.75,
  randomseed = NULL,
  lambda = 0.1,
  distr = "Exp",
  rho_w = 1,
  drop_out = 0.3
)
}
\arguments{
\item{N}{sample size, 300 by default}

\item{observe_time}{study's observation time, 10 by default}

\item{percentcensored}{expected number of non-events by observe_time, 0.75 by default (i.e. event rate is 0.25)}

\item{randomseed}{random seed for replication}

\item{lambda}{baseline hazard rate, 0.1 by default}

\item{distr}{time-to-event distribution, "Exp" for exponential (default), "W" for Weibull}

\item{rho_w}{shape parameter for Weibull distribution, 0.3 by default}

\item{drop_out}{expected rate of drop out before observe_time, 0.3 by default}
}
\value{
data frame; "time" and "event" columns describe survival outcome; predictors are "age", "sex", "hyp", "bmi"
}
\description{
Simulated sample with exponentially or Weibull distributed time-to-event;
log-hazard depends non-linearly on risk factors, and includes cross-terms.
}
\examples{
mydata <- simulate_crossterms()
head(mydata)
}
