% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{grad_rho_mult}
\alias{grad_rho_mult}
\title{Gradient vector of LCV and LAML wrt rho (log smoothing parameters). Version for multiplicative decomposition : relative mortality ratio model}
\usage{
grad_rho_mult(
  X_GL,
  GL_temp,
  haz_GL,
  deriv_rho_beta,
  weights,
  tm,
  nb_smooth,
  p,
  n_legendre,
  S_list,
  temp_LAML,
  Vp,
  S_beta,
  beta,
  inverse_new_S,
  X,
  event,
  expected,
  Ve,
  mat_temp,
  method
)
}
\arguments{
\item{X_GL}{list of matrices (\code{length(X.GL)=n.legendre}) for Gauss-Legendre quadrature}

\item{GL_temp}{list of vectors used to make intermediate calculations and save computation time}

\item{haz_GL}{list of all the matrix-vector multiplications X.GL[[i]]\%*\%beta for Gauss Legendre integration in order to save computation time}

\item{deriv_rho_beta}{firt derivative of beta wrt rho (implicit differentiation)}

\item{weights}{vector of weights for Gauss-Legendre integration on [-1;1]}

\item{tm}{vector of midpoints times for Gauss-Legendre integration; tm = 0.5*(t1 - t0)}

\item{nb_smooth}{number of smoothing parameters}

\item{p}{number of regression parameters}

\item{n_legendre}{number of nodes for Gauss-Legendre quadrature}

\item{S_list}{List of all the rescaled penalty matrices multiplied by their associated smoothing parameters}

\item{temp_LAML}{temporary matrix used when method="LAML" to save computation time}

\item{Vp}{Bayesian covariance matrix}

\item{S_beta}{List such that S_beta[[i]]=S_list[[i]]\%*\%beta}

\item{beta}{vector of estimated regression parameters}

\item{inverse_new_S}{inverse of the penalty matrix}

\item{X}{design matrix for the model}

\item{event}{vector of right-censoring indicators}

\item{expected}{vector of expected hazard rates}

\item{Ve}{frequentist covariance matrix}

\item{mat_temp}{temporary matrix used when method="LCV" to save computation time}

\item{method}{criterion used to select the smoothing parameters. Should be "LAML" or "LCV"; default is "LAML"}
}
\value{
List of objects with the following items:
\item{grad_rho}{gradient vector of LCV or LAML}
\item{deriv_rho_inv_Hess_beta}{List of first derivatives of Vp wrt rho}
\item{deriv_rho_Hess_unpen_beta}{List of first derivatives of the Hessian of the unpenalized log-likelihood wrt rho}
}
\description{
Gradient vector of LCV and LAML wrt rho (log smoothing parameters). Version for multiplicative decomposition : relative mortality ratio model
}
