% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_01.r
\name{smooth.cons.integral}
\alias{smooth.cons.integral}
\title{Design matrix of penalized splines in a smooth.spec object for Gauss-Legendre quadrature}
\usage{
smooth.cons.integral(term, knots, df, by = NULL, option, data.spec,
  Z.smf, Z.tensor, Z.tint, name)
}
\arguments{
\item{term}{Vector of strings that generally comes from the value "term" of a smooth.spec object}

\item{knots}{List of numeric vectors that specifies the knots of the splines (including boundaries).}

\item{df}{Degrees of freedom : numeric vector that indicates the number of knots desired for each covariate.}

\item{by}{numeric or factor variable in order to define a varying coefficient smooth; default is NULL.}

\item{option}{"smf", "tensor" or "tint".}

\item{data.spec}{data frame that represents the environment from which the covariate values and knots are to be calculated; default is NULL.}

\item{Z.smf}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{smf}} splines.}

\item{Z.tensor}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{tensor}} splines.}

\item{Z.tint}{List of matrices that represents the sum-to-zero constraint to apply for \code{\link{tint}} splines.}

\item{name}{simplified name of the smooth.spec call.}
}
\value{
design matrix
}
\description{
Almost identical to \code{\link{smooth.cons}}. This version is dedicated to Gauss-Legendre
quadrature. Here, the sum-to-zero constraints must be specified so that they correspond to the ones that
were calculated with the initial dataset.
}
