% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{test_functions}
\alias{test_functions}
\alias{shaffer1}
\alias{shaffer2}
\alias{fonseca}
\alias{kursawe}
\alias{viennet}
\alias{binh}
\title{nowacki_beam_tps'
Test functions for optimization}
\usage{
shaffer1(x)

shaffer2(x)

fonseca(x)

kursawe(x)

viennet(x)

binh(x)
}
\arguments{
\item{x, }{numeric value (or vector for multivariable functions)}
}
\description{
This page is a collection of test functions commonly used to test optimization algorithms
}
\examples{

#function should be evaluated in the -A < x < A interval,
#where A is from 10 to 10^5 and \\length(x) = 1
shaffer1(0)

#function should be evaluated in the -5 < x < 10 interval \\length(x) = 1
shaffer2(0)

#function should be evaluated in the -20 < x < 20 interval and \\length(x) >= 1
fonseca(rep(0,10))

#function should be evaluated in the -5 < x < 5 interval and \\length(x) == 3
kursawe(rep(0,3))

#function should be evaluated in the -3 < x < 3 interval and \\length(x) == 2
viennet(c(0.5,0.5))

#function should be evaluated in the 0 < x < (5,3) interval and \\length(x) == 2
binh(c(0,0))
}
\references{
\url{https://en.wikipedia.org/wiki/Test_functions_for_optimization}

\url{http://www.sfu.ca/~ssurjano/optimization.html}
}
