% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_css.R
\name{st_css}
\alias{st_css}
\title{Include \strong{summarytools}' \emph{css} Into Active Document}
\usage{
st_css(main = TRUE, global = FALSE, bootstrap = FALSE,
  style.tag = TRUE, ...)
}
\arguments{
\item{main}{Logical. Include \emph{summarytools.css} file. \code{TRUE} by
default. Affects only \strong{summarytools} objects.}

\item{global}{Logical. Include the additional \emph{summarytools-global.css}
file, which affects all content in the document. Provides control over
objects that were not \emph{html-rendered}; in particular, table widths
and vertical alignment are modified to improve layout. \code{FALSE} by
default.}

\item{bootstrap}{Logical. Include \emph{bootstrap.min.css}. \code{FALSE}
by default.}

\item{style.tag}{Logical. Includes the opening and closing \code{<style>}
tags. \code{TRUE} by default.}

\item{\dots}{Character. Path to additional \emph{css} file(s) to include.}
}
\description{
Generates the \emph{css} needed by \strong{summarytools} in \emph{Rmarkdown} 
documents.
}
\details{
Typically the function is called in the first R chunk of an 
  \emph{Rmarkdown} document. For instance:
  \code{
  ```{r, include=FALSE}
  library(knitr)
  opts_chunk$set(results = "asis")
  library(summarytools)
  st_options(plain.ascii = FALSE, style = "rmarkdown")
  st_css()
  ```
  }
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{utilities}
