% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{st_options}
\alias{st_options}
\title{Displaying and setting summarytools global options}
\usage{
st_options(option, value)
}
\arguments{
\item{option}{option name (string).}

\item{value}{value to assign (optional)}
}
\description{
To list all \code{summarytools} global options, run this function without any parameters. 
To display the value of an option, use the first parameter only. To modify it, add the new
value as a second parameter.
}
\details{
The following options are available:

\itemize{
  \item \code{style}  Character. One of \dQuote{simple} (default), \dQuote{rmarkdown}, or
    \dQuote{grid}.
  \item \code{plain.ascii}  Logical. \code{TRUE} by default. Set to \code{FALSE} when using
    summarytools with a rendering tool such as \code{knitr} or when creating rmarkdown output
    files to be converted with Pandoc (although note that its value will automatically be set to
    \code{FALSE} whenever \code{style} = \dQuote{rmarkdown}).
  \item \code{round.digits}  Numeric. Defaults to \code{2}.
  \item \code{omit.headings}  Logical. Set to \code{TRUE} to remove all headings from outputs
    (only the tables will be printed out). \code{FALSE} by default.
  \item \code{footnote}  Character. When the default value \dQuote{default} is used, the 
    package name, version, and R version are displayed below html outputs. Set no \code{NA} to omit
    the footnote, or provide a string to personalize it.
  \item \code{display.labels}  Logical. \code{TRUE} by default. Set to \code{FALSE} to omit data 
    frame and variable labels in the headings section.
  \item \code{freq.totals}  Logical. Corresponds to the \code{totals} parameter of \code{\link{freq}}.
    \code{TRUE} by default.
  \item \code{freq.display.nas}  Logical. Corresponds to the \code{display.nas} parameter of 
    \code{freq()}. \code{TRUE} by default.
  \item \code{ctable.totals}  Logical. Corresponds to the \code{totals} parameter of 
    \code{\link{ctable}}. \code{TRUE} by default.
  \item \code{ctable.prop}  Character. Corresponds to the \code{prop} parameter of 
    \code{\link{ctable}}. Defaults to \dQuote{r} (\emph{r}ow).
  \item \code{descr.stats}  Character. Corresponds to the \code{stats} parameter of 
    \code{\link{descr}}. Defaults to \dQuote{all}.
  \item \code{descr.transpose}  Logical. Corresponds to the \code{transpose} parameter of 
    \code{\link{descr}}. \code{FALSE} by default.
  \item \code{bootstrap.css}  Logical.  Include Bootstrap CSS in html outputs. Defaults to 
    \code{TRUE}. Set to \code{FALSE} When using the \dQuote{render} method inside a 
    \code{shiny} app.  
  \item \code{custom.css}  Character. Path to an additional, user-provided, CSS file. \code{NA} 
    by default.
  \item \code{escape.pipe}  Logical. Set to \code{TRUE} if Pandoc conversion
    is your goal and you have unsatisfying results with grid or multiline tables.
    \code{FALSE} by default.
    
}
}
\note{
Loosely based on Gergely Daróczi's \code{\link[pander]{panderOptions}} function.
}
\examples{
\dontrun{
st_options()                   # show all summarytools global options
st_options('round.digits')     # show a specific global option 
st_options('round.digits', 1)  # set an option
st_options('reset')            # reset all summarytools global options
}
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com},
}
