% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summed-class.R
\name{summed-objects}
\alias{summed-objects}
\alias{print.summed}
\alias{as.double.summed}
\title{S3 Class for objects containing iterated summations}
\usage{
\method{print}{summed}(x, ...)

\method{as.double}{summed}(x, ...)
}
\arguments{
\item{x}{The \code{summed} object.}

\item{...}{Currently unused.}
}
\value{
For \code{print}: The invisible object.

For \code{as.numeric}/\code{as.double}: The approximated sum.
}
\description{
Contains the summations in the log scale. The value can either be an
approximation to an infinite series or a finite sum.
}
\section{Elements in the list}{

\describe{
\item{\code{sum}}{The resulting sum in the log scale.}
\item{\code{n}}{The performed number of iterations. This value represents
the number of series elements evaluations performed during the summation.}
\item{\code{method}}{The method used for the summation.}
\item{\code{maxReached}}{\code{TRUE} or \code{FALSE}. Indicates whether the
maximum iterations was reached.}
}
}

\seealso{
\code{\link{infiniteSum}}, \code{\link{infiniteSum_batches}} and
\code{\link{finiteSum}} for available methods.
}
