% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectivematrices.R
\name{objectivematrices}
\alias{objectivematrices}
\title{Generate matrix-components for objective functions.}
\usage{
objectivematrices(
  data,
  factor.structure,
  capacity = NULL,
  matrices = c("lvcor"),
  n.random = 0,
  item.invariance = "congeneric",
  repeated.measures = NULL,
  long.invariance = "strict",
  mtmm = NULL,
  mtmm.invariance = "configural",
  grouping = NULL,
  group.invariance = "strict",
  comparisons = NULL,
  auxiliary = NULL,
  use.order = FALSE,
  software = "lavaan",
  cores = NULL,
  objective = NULL,
  ignore.errors = FALSE,
  analysis.options = NULL,
  suppress.model = FALSE,
  ...
)
}
\arguments{
\item{data}{A data.frame containing all relevant data.}

\item{factor.structure}{A list linking factors to items. The names of the list elements correspond to the factor names. Each list element must contain a character-vector of item names that are indicators of this factor.}

\item{capacity}{A list containing the number of items per subtest. This must be in the same order as the \code{factor.structure} provided. If a single number, it is applied to all subtests. If \code{NULL} all items are evenly distributed among the subtests.}

\item{matrices}{Which matrix to extract. Can be one of \code{'lvcor'} (the default) for latent correlations, 'lambda', 'theta', 'psi', or 'alpha' for the model-implied matrices.}

\item{n.random}{The number of random draws to base values on. If 0 (the default) values are in the matrices are set to 0 and can be overwritten later. If any value larger than 0, the mean from \code{n.random} random solutions is used.}

\item{item.invariance}{A character vector of length 1 or the same length as \code{factor.structure} containing the desired invariance levels between items pertaining to the same subtest. Currently there are five options: 'congeneric', 'ess.equivalent', 'ess.parallel', 'equivalent', and 'parallel', the first being the default.}

\item{repeated.measures}{A list linking factors that are repeated measures of each other. Repeated factors must be in one element of the list - other sets of factors in other elements of the list. When this is \code{NULL} (the default) a cross-sectional model is estimated.}

\item{long.invariance}{A character vector of length 1 or the same length as \code{repeated.measures} containing the longitudinal invariance level of repeated items. Currently there are four options: 'configural', 'weak', 'strong', and 'strict'. Defaults to 'strict'. When \code{repeated.measures=NULL} this argument is ignored.}

\item{mtmm}{A list linking factors that are measurements of the same construct with different methods. Measurements of the same construct must be in one element of the list - other sets of methods in other elements of the list. When this is \code{NULL} (the default) a single method model is estimated.}

\item{mtmm.invariance}{A character vector of length 1 or the same length as \code{mtmm} containing the invariance level of MTMM items. Currently there are five options: 'none', 'configural', 'weak', 'strong', and 'strict'. Defaults to 'configural'. With 'none' differing items are allowed for different methods. When \code{mtmm=NULL} this argument is ignored.}

\item{grouping}{The name of the grouping variable. The grouping variable must be part of \code{data} provided and must be a numeric variable.}

\item{group.invariance}{A single value describing the assumed invariance of items across groups. Currently there are four options: 'configural', 'weak', 'strong', and 'strict'. Defaults to 'strict'. When \code{grouping=NULL} this argument is ignored.}

\item{comparisons}{A character vector containing any combination of 'item', 'long', 'mtmm', and 'group' indicating which invariance should be assessed via model comparisons. The order of the vector dictates the sequence in which model comparisons are performed. Defaults to \code{NULL} meaning that no model comparisons are performed.}

\item{auxiliary}{The names of auxiliary variables in \code{data}. These can be used in additional modeling steps that may be provided in \code{analysis.options$model}.}

\item{use.order}{A logical indicating whether or not to take the selection order of the items into account. Defaults to \code{FALSE}.}

\item{software}{The name of the estimation software. Can currently be 'lavaan' (the default) or 'Mplus'. Each option requires the software to be installed.}

\item{cores}{The number of cores to be used in parallel processing. If \code{NULL} (the default) the result of \code{\link[parallel]{detectCores}} will be used. On Unix-y machines parallel processing is implemented via \code{\link[parallel]{mclapply}}, on Windows machines it is realized via \code{\link[parallel]{parLapply}}.}

\item{objective}{A function that converts the results of model estimation into a pheromone. See 'details' for... details.}

\item{ignore.errors}{A logical indicating whether or not to ignore estimation problems (such as non positive-definite latent covariance matrices). Defaults to \code{FALSE}.}

\item{analysis.options}{A list additional arguments to be passed to the estimation software. The names of list elements must correspond to the arguments changed in the respective estimation software. E.g. \code{analysis.options$model} can contain additional modeling commands - such as regressions on auxiliary variables.}

\item{suppress.model}{A logical indicating whether to suppress the default model generation. If \code{TRUE} a model must be provided in \code{analysis.options$model}.}

\item{...}{Additional arguments passed either to \code{\link{randomsamples}} or to \code{lavaan}.}
}
\value{
Returns an object of class \code{stuartFixedObjective}
}
\description{
Generate objects of the correct structure for use in custom objective functions.
}
\examples{

# Extract latent correlation matric
# requires lavaan
# number of cores set to 1 in all examples
data(sups)
fs <- list(pro = names(sups)[2:13],
 fee = names(sups)[14:20])

mats <- objectivematrices(sups, fs, 3,
  cores = 1)
mats

mats$lvcor$use[,] <- FALSE
mats$lvcor$use[2, 1] <- TRUE

mats$lvcor$use

}
\seealso{
\code{\link{empiricalobjective}}, \code{\link{extractobjective}}, \code{\link{objectivematrices}}
}
\author{
Martin Schultze
}
