% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractobjective.R
\name{extractobjective}
\alias{extractobjective}
\title{Extracting empirical objective functions for item selection}
\usage{
extractobjective(
  x,
  n = 50,
  side = c("top", "bottom", "center"),
  skew = FALSE,
  scale = 1,
  ...
)
}
\arguments{
\item{x}{A vector of values for which to determine the objective function (e.g. RMSEA).}

\item{n}{Number of values to use in function determining. Defaults to 50.}

\item{side}{Which side good values are located at. \code{'top'} means large values are good (e.g. Reliability), \code{'bottom'} means small values are good (e.g. RMSEA), and \code{'middle'} means average values are good (e.g. factor correlations).}

\item{skew}{Whether to account for skew in the distribution using the [sn::psn()] function. Defaults to \code{FALSE}, meaning a normal distribution is used.}

\item{scale}{A numeric scale to use in weighting the objective component. Defaults to 1.}

\item{...}{Additional arguments.}
}
\value{
Returns an object of class \code{stuartEmpiricalObjective}.
}
\description{
This is a bare-bones initial version of this approach.
}
\seealso{
\code{\link{empiricalobjective}}, \code{\link{fixedobjective}}, \code{\link{objectivematrices}}
}
\author{
Martin Schultze
}
\keyword{internal}
