% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripless-internal.R
\name{stripless-internal}
\alias{check2lvl}
\alias{chkSpacings}
\alias{makeSpacings}
\alias{make_2level_with_center}
\alias{stripless-internal}
\alias{xyLayout}
\alias{xyLayout.data.frame}
\alias{xyLayout.default}
\alias{xyLayout.list}
\alias{xyLayout.matrix}
\title{Unexported Utility and xyLayout Functions}
\usage{
check2lvl(d, sep = ".")

make_2level_with_center(lvls, sep = ".")

makeSpacings(spacings, levelLength)

chkSpacings(spacings)

xyLayout(xylay, ...)

\method{xyLayout}{list}(xylay = list(),
  n = stop("Number of conditioning factors is missing"))

\method{xyLayout}{matrix}(xylay, n)

\method{xyLayout}{data.frame}(xylay, n)

\method{xyLayout}{default}(..., n)
}
\arguments{
\item{d}{Condition list from strucParseFormula to be checked to see if it
represents a 2 level design with center point.}

\item{sep}{sep argument for \code{paste()}.}

\item{lvls}{A list of length 3 character vectors that are the level names of
factors in a design to be checked.}

\item{spacings}{A non-decreasing vector of positive values}

\item{levelLength}{An integer vector giving the number of levels per factor
at each level of the plotting hierarchy}

\item{xylay}{An appropriate list, matrix, or vector for determining the
plot structure. Can also be missing, length 0, etc.}

\item{n}{The number of conditioning factors. The integers in the combined list
that is created will be a permutation of 1, 2, \ldots ,n .}

\item{\ldots}{x and/or y vector for \code{xylay} list. The remaining component will be
constructed as needed.}
}
\value{
For \code{xyLayout}: a list of class "xyLayout" suitable for the \code{xyLayout} argument of \code{strucplot}.
}
\description{
Unexported functions not intended to be directly called by users.

For \code{xyLayout}: Unexported generic and methods used by \code{strucplot} to
create, check and/or fix a \code{xyLayout} list.
}
\details{
\strong{Brief utility function descriptions:}
\describe{
 \item{check2lvl}{Checks for a 2 level design with center point}
 \item{make_2level_with_center}{Makes a 2 level design with center point to
  compare to a fraction of a \eqn{3^n} design}
 \item{chkSpacings}{Checks and constructs proper spacings list if possible}
 \item{makeSpacings}{Constructs a vector of spacings values for the "between"
  argument of \code{\link[lattice]{xyplot}}}
  }

\strong{xyLayout:}
The various methods provide convenience and flexibility for specifying
the \code{xyLayout} list argument that controls the format of \code{strucplot}
displays. Essentially any sensible way of specifying \code{xyLayout} should
work. See the Help page for \code{\link{strucplot}} for details.
}
\seealso{
\code{\link{strucplot}}
}

