% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.r
\name{str_count}
\alias{str_count}
\title{Count the number of matches in a string.}
\usage{
str_count(string, pattern = "")
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described
in \link[stringi:about_search_regex]{stringi::stringi-search-regex}. Control options with
\code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}
}
\value{
An integer vector.
}
\description{
Vectorised over \code{string} and \code{pattern}.
}
\examples{
fruit <- c("apple", "banana", "pear", "pineapple")
str_count(fruit, "a")
str_count(fruit, "p")
str_count(fruit, "e")
str_count(fruit, c("a", "b", "p", "p"))

str_count(c("a.", "...", ".a.a"), ".")
str_count(c("a.", "...", ".a.a"), fixed("."))
}
\seealso{
\code{\link[stringi:stri_count]{stringi::stri_count()}} which this function wraps.

\code{\link[=str_locate]{str_locate()}}/\code{\link[=str_locate_all]{str_locate_all()}} to locate position
of matches
}
