% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate.r
\name{invert_match}
\alias{invert_match}
\title{Switch location of matches to location of non-matches.}
\usage{
invert_match(loc)
}
\arguments{
\item{loc}{matrix of match locations, as from \code{\link[=str_locate_all]{str_locate_all()}}}
}
\value{
numeric match giving locations of non-matches
}
\description{
Invert a matrix of match locations to match the opposite of what was
previously matched.
}
\examples{
numbers <- "1 and 2 and 4 and 456"
num_loc <- str_locate_all(numbers, "[0-9]+")[[1]]
str_sub(numbers, num_loc[, "start"], num_loc[, "end"])

text_loc <- invert_match(num_loc)
str_sub(numbers, text_loc[, "start"], text_loc[, "end"])
}
