% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{stri_remove_empty}
\alias{stri_remove_empty}
\alias{stri_omit_empty}
\alias{stri_remove_empty_na}
\alias{stri_omit_empty_na}
\alias{stri_remove_na}
\alias{stri_omit_na}
\title{Remove All Empty Strings from a Character Vector}
\usage{
stri_remove_empty(x, na_empty = FALSE)

stri_omit_empty(x, na_empty = FALSE)

stri_remove_empty_na(x)

stri_omit_empty_na(x)

stri_remove_na(x)

stri_omit_na(x)
}
\arguments{
\item{x}{a character vector}

\item{na_empty}{should missing values be treated as empty strings?}
}
\value{
Returns a character vector.
}
\description{
\code{stri_remove_empty} (alias \code{stri_omit_empty})
removes all empty strings from a character vector,
and, if \code{na_empty} is \code{TRUE}, also gets rid of all missing
values.

\code{stri_remove_empty_na} (alias \code{stri_omit_empty_na})
removes both empty strings and missing values.

\code{stri_remove_na} (alias \code{stri_omit_na})
returns a version of \code{x} with missing values removed.
}
\examples{
stri_remove_empty(stri_na2empty(c('a', NA, '', 'b')))
stri_remove_empty(c('a', NA, '', 'b'))
stri_remove_empty(c('a', NA, '', 'b'), TRUE)

stri_omit_empty_na(c('a', NA, '', 'b'))

}
\seealso{
Other utils: 
\code{\link{stri_list2matrix}()},
\code{\link{stri_na2empty}()},
\code{\link{stri_replace_na}()}
}
\concept{utils}
