% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{stri_read_lines}
\alias{stri_read_lines}
\title{Read Text Lines from a Text File}
\usage{
stri_read_lines(con, encoding = NULL, fname = con, fallback_encoding = NULL)
}
\arguments{
\item{con}{name of the output file or a connection object
(opened in the binary mode)}

\item{encoding}{single string; input encoding;
\code{NULL} or \code{''} for the current default encoding.}

\item{fname}{deprecated alias of \code{con}}

\item{fallback_encoding}{deprecated argument, no longer used}
}
\value{
Returns a character vector, each text line is a separate string.
The output is always marked as UTF-8.
}
\description{
Reads a text file in ins entirety, re-encodes it, and splits it into text lines.
}
\details{
This aims to be a substitute for the \code{\link{readLines}} function,
with the ability to re-encode the input file in a much more robust way,
and split the text into lines with \code{\link{stri_split_lines1}}
(which conforms with the Unicode guidelines for newline markers).

The function calls \code{\link{stri_read_raw}},
\code{\link{stri_encode}}, and \code{\link{stri_split_lines1}},
in this order.

Because of the way this function is currently implemented,
maximal file size cannot exceed ~0.67 GB.
}
\seealso{
Other files: 
\code{\link{stri_read_raw}()},
\code{\link{stri_write_lines}()}
}
\concept{files}
