% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_subset_4.R
\name{stri_subset}
\alias{stri_subset}
\alias{stri_subset<-}
\alias{stri_subset_fixed}
\alias{stri_subset_fixed<-}
\alias{stri_subset_charclass}
\alias{stri_subset_charclass<-}
\alias{stri_subset_coll}
\alias{stri_subset_coll<-}
\alias{stri_subset_regex}
\alias{stri_subset_regex<-}
\title{Select Elements that Match a Given Pattern}
\usage{
stri_subset(str, ..., regex, fixed, coll, charclass)

stri_subset(str, ..., regex, fixed, coll, charclass) <- value

stri_subset_fixed(str, pattern, omit_na = FALSE, negate = FALSE, ...,
  opts_fixed = NULL)

stri_subset_fixed(str, pattern, negate=FALSE, ..., opts_fixed=NULL) <- value

stri_subset_charclass(str, pattern, omit_na = FALSE, negate = FALSE)

stri_subset_charclass(str, pattern, negate=FALSE) <- value

stri_subset_coll(str, pattern, omit_na = FALSE, negate = FALSE, ...,
  opts_collator = NULL)

stri_subset_coll(str, pattern, negate=FALSE, ..., opts_collator=NULL) <- value

stri_subset_regex(str, pattern, omit_na = FALSE, negate = FALSE, ...,
  opts_regex = NULL)

stri_subset_regex(str, pattern, negate=FALSE, ..., opts_regex=NULL) <- value
}
\arguments{
\item{str}{character vector; strings to search in}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{opts_collator}, \code{opts_regex},
\code{opts_fixed}, and so on}

\item{value}{character vector to be substituted with; replacement function only}

\item{pattern, regex, fixed, coll, charclass}{character vector;
search patterns; for more details refer to \link{stringi-search};
the replacement functions accept only one pattern at a time}

\item{omit_na}{single logical value; should missing values be excluded
from the result?}

\item{negate}{single logical value; whether a no-match is rather of interest}

\item{opts_collator, opts_fixed, opts_regex}{a named list used to tune up
the search engine's settings; see
\code{\link{stri_opts_collator}}, \code{\link{stri_opts_fixed}},
and \code{\link{stri_opts_regex}}, respectively; \code{NULL}
for the defaults}
}
\value{
The \code{stri_subset} functions return a character vector.
As usual, the output encoding is always UTF-8.

The \code{stri_subset<-} function modifies the \code{str} object
``in-place''.
}
\description{
These functions return or modify a sub-vector where there is a match
a given pattern. In other words, they
are roughly equivalent (but faster and easier to use) to a call to
\code{str[\link{stri_detect}(str, ...)]} or
\code{str[\link{stri_detect}(str, ...)] <- value}.
}
\details{
Vectorized over \code{str}, and \code{pattern} or \code{value}
(replacement version).

\code{stri_subset} and \code{stri_subset<-} are convenience functions.
They call either \code{stri_subset_regex},
\code{stri_subset_fixed}, \code{stri_subset_coll},
or \code{stri_subset_charclass},
depending on the argument used.
}
\examples{
stri_subset_regex(c("stringi R", "123", "ID456", ""), "^[0-9]+$")

x <- c("stringi R", "123", "ID456", "")
stri_subset_regex(x, "[^0-9]+|^$") <- NA
print(x)

x <- c("stringi R", "123", "ID456", "")
stri_subset_regex(x, "^[0-9]+$", negate=TRUE) <- NA
print(x)

}
\seealso{
Other search_subset: \code{\link{stringi-search}}
}
\concept{search_subset}
