% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{stringi-search-coll}
\alias{stringi-search-coll}
\title{Locale-Sensitive Text Searching in \pkg{stringi}}
\description{
String searching facilities described in this very man page
provide a way to locate a specific piece of
text. Note that locale-sensitive searching, especially
on a non-English text, is a much more complex process
than it seems at the first glance.
}
\section{Locale-Aware String Search Engine}{


All \code{stri_*_coll} functions in \pkg{stringi} utilize
\pkg{ICU}'s \code{StringSearch} engine --
which implements a locale-sensitive string search algorithm.
The matches are defined by using the notion of ``canonical equivalence''
between strings.

Tuning the Collator's parameters allows you to perform correct matching
that properly takes into account accented letters, conjoined letters,
ignorable punctuation and letter case.

For more information on \pkg{ICU}'s Collator and the search engine
and how to tune it up
in \pkg{stringi}, refer to \code{\link{stri_opts_collator}}.

Please note that \pkg{ICU}'s \code{StringSearch}-based functions
often exhibit poor performance. These functions are not intended to
be fast; they are made to give \emph{correct} in natural
language processing tasks.
}
\references{
\emph{ICU String Search Service} -- ICU User Guide,
 \url{http://userguide.icu-project.org/collation/icu-string-search-service}

L. Werner, \emph{Efficient Text Searching in Java}, 1999,
\url{http://icu-project.org/docs/papers/efficient_text_searching_in_java.html}
}
\seealso{
Other locale_sensitive: \code{\link{\%s<\%}},
  \code{\link{stri_compare}},
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_duplicated}},
  \code{\link{stri_enc_detect2}},
  \code{\link{stri_extract_all_boundaries}},
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_opts_collator}},
  \code{\link{stri_order}},
  \code{\link{stri_split_boundaries}},
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_unique}}, \code{\link{stri_wrap}},
  \code{\link{stringi-locale}},
  \code{\link{stringi-search-boundaries}}

Other search_coll: \code{\link{stri_opts_collator}},
  \code{\link{stringi-search}}

Other stringi_general_topics: \code{\link{stringi-arguments}},
  \code{\link{stringi-encoding}},
  \code{\link{stringi-locale}},
  \code{\link{stringi-package}},
  \code{\link{stringi-search-boundaries}},
  \code{\link{stringi-search-charclass}},
  \code{\link{stringi-search-fixed}},
  \code{\link{stringi-search-regex}},
  \code{\link{stringi-search}}
}

