% Generated by roxygen2 (4.0.0): do not edit by hand
\name{\%+\%}
\alias{\%+\%}
\alias{\%stri+\%}
\title{Concatenate Two Character Vectors}
\usage{
e1 \%+\% e2

e1 \%stri+\% e2

e1 \%stri+\% e2
}
\arguments{
\item{e1}{character vector or an object coercible to a character vector}

\item{e2}{character vector or an object coercible to a character vector}
}
\value{
Returns a character vector.
}
\description{
Binary operators for joining (concatenating) two character vectors,
with a typical \R look-and-feel.
}
\details{
Vectorized over \code{e1} and \code{e2}.

These operators act like a call to \code{\link{stri_join}(e1, e2, sep="")}.
However, note that joining 3 vectors, e.g. \code{e1 \%+\% e2 \%+\% e3}
is slower than \code{\link{stri_join}(e1, e2, e3, sep="")},
because it creates a new (temporary) result vector each time
the operator is applied.
}
\examples{
\dontshow{if (stri_install_check(silent=TRUE))}
c('abc', '123', '\\u0105\\u0104') \%stri+\% letters[1:6]

\dontshow{if (stri_install_check(silent=TRUE))}
'ID_' \%stri+\% 1:5
}

