% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdist.R
\docType{package}
\name{stringdist-package}
\alias{stringdist-package}
\title{A package for string distance calculation and approximate string matching.}
\description{
A package for string distance calculation and approximate string matching.
}
\section{Introduction}{


The \pkg{stringdist} package offers fast and platform-independent string
metrics. Its main purpose is to compute various string distances and to do 
approximate text matching between character vectors. As of version 0.9.3,
it is also possible to compute distances between sequences represented by
integer vectors.


A typical use is to match strings that are not precisely the same. For
example

\code{  amatch(c("hello","g'day"),c("hi","hallo","ola"),maxDist=2)}

returns \code{c(2,NA)} since \code{"hello"} matches closest with
\code{"hallo"}, and within the maximum (optimal string alignment) distance.
The second element, \code{"g'day"}, matches closest with \code{"ola"} but
since the distance equals 4, no match is reported.

A second typical use is to compute string distances. For example 

\code{  stringdist(c("g'day"),c("hi","hallo","ola"))}

Returns \code{c(5,5,4)} since these are the distances between \code{"g'day"}
and respectively \code{"hi"}, \code{"hallo"}, and \code{"ola"}.

A third typical use would be to compute a \code{dist} object. The command

\code{stringdistmatrix(c("foo","bar","boo","baz"))}

returns an object of class \code{dist} that can be used by clustering
algorithms such as \code{stats::hclust}.

A fourth use is to compute string distances between general sequences,
represented as integer vectors (which must be stored in a \code{list}):

\code{seq_dist( list(c(1L,1L,2L)), list(c(1L,2L,1L),c(2L,3L,1L,2L)) )}

The above code yields the vector \code{c(1,2)} (the first shorter first
argument is recycled over the longer second argument)

Besides documentation for each function, the main topics documented are:

\itemize{
\item{\code{\link{stringdist-metrics}} -- string metrics supported by the package}
\item{\code{\link{stringdist-encoding}} -- how encoding is handled by the package}
\item{\code{\link{stringdist-parallelization}} -- on multithreading }
}
}

\section{Acknowledgements}{

\itemize{
  \item{The code for the full Damerau-Levenshtein distance was adapted from Nick Logan's
  \href{https://github.com/ugexe/Text--Levenshtein--Damerau--XS/blob/master/damerau-int.c}{public github repository}.}
  \item{C code for converting UTF-8 to integer was copied from the R core for performance reasons.}
  \item{The code for soundex conversion and string similarity was kindly contributed by Jan van der Laan.}
}
}

\section{Citation}{

If you would like to cite this package, please cite the \href{https://journal.r-project.org/archive/2014-1/loo.pdf}{R Journal Paper}: 
\itemize{
\item{M.P.J. van der Loo (2014). The \code{stringdist} package for approximate string matching. 
 R Journal 6(1) pp 111-122}
}
Or use \code{citation('stringdist')} to get a bibtex item.
}

