% Generated by roxygen2 (4.0.1): do not edit by hand
\name{printable_ascii}
\alias{printable_ascii}
\title{Detect the presence of non-printable or non-ascii characters}
\usage{
printable_ascii(x)
}
\arguments{
\item{x}{a \code{character} vector}
}
\value{
A \code{logical} indicating which elements consist solely of printable ASCII characters.
}
\description{
Detect the presence of non-printable or non-ascii characters
}
\details{
Printable ASCII characters consist of space, \code{A-Z}, \code{a-z}, \code{0-9} and the characters

\code{! "" # $ \% & ' ( ) * + , . / : ; < = > ? @ [ ] \\ ^ _ ` { | } ~ -}

Note that this excludes tab (as it is a control character).
}
\section{Some tips on character encoding and transliteration}{

Some algorithms (like soundex) are defined only on the printable ASCII character set. This excludes any character
with accents for example. Translating accented characters to the non-accented ones is a form of transliteration. On
most systems running R you can achieve this with

\code{iconv(x,"ASCII//TRANSLIT")},

where \code{x} is your character vector. See the documentation of \code{\link[base]{iconv}} for details.

The \code{stringi} package (Gagolewski and Tartanus) should work on any system. The command
\code{stringi::stri_trans_general(x,"Latin-ASCII")} transliterates character vector \code{x} to ASCII.
}
\examples{
# define o-umlaut
ouml <- intToUtf8("0x00F6")
x <- c("Motorhead", paste0("Mot",ouml,"rhead"))
# second element contains a non-ascii character
printable_ascii(x)

# Control characters (like carriage return) are also excluded
printable_ascii("abc\\r")


}

