% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-nums.R
\name{str_nth_number}
\alias{str_nth_number}
\alias{str_first_number}
\alias{str_last_number}
\title{Extract the \code{n}th number from a string.}
\usage{
str_nth_number(
  string,
  n,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  commas = FALSE,
  leave_as_string = FALSE
)

str_first_number(
  string,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  commas = FALSE,
  leave_as_string = FALSE
)

str_last_number(
  string,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  commas = FALSE,
  leave_as_string = FALSE
)
}
\arguments{
\item{string}{A string.}

\item{n}{A vector of integerish values. Must be either length 1 or
have length equal to the length of \code{string}. Negative indices count from
the back: while \code{n = 1} and \code{n = 2} correspond to first and second, \code{n = -1} and \code{n = -2} correspond to last and second-last. \code{n = 0} will return
\code{NA}.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{sci}{Make the search aware of scientific notation e.g. 2e3 is the same
as 2000.}

\item{commas}{Allow comma separators in numbers (i.e. interpret 1,100 as a
single number (one thousand one hundred) rather than two numbers (one and
one hundred)).}

\item{leave_as_string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}
}
\value{
A numeric vector (or a character vector if \code{leave_as_string = TRUE}).
}
\description{
Extract the \code{n}th number from a string, where decimals, scientific notation
and commas (as separators, not as an alternative to the decimal point) are
optionally allowed.
}
\details{
\itemize{ \item \code{str_first_number(...)} is just \code{str_nth_number(..., n = 1)}.
\item \code{str_last_number(...)} is just \code{str_nth_number(..., n = -1)}. }

For a detailed explanation of the number extraction, see
\code{\link[=str_extract_numbers]{str_extract_numbers()}}.
}
\examples{
strings <- c(
  "abc123def456", "abc-0.12def.345", "abc.12e4def34.5e9",
  "abc1,100def1,230.5", "abc1,100e3,215def4e1,000"
)
str_nth_number(strings, n = 2)
str_nth_number(strings, n = -2, decimals = TRUE)
str_first_number(strings, decimals = TRUE, leading_decimals = TRUE)
str_last_number(strings, commas = TRUE)
str_nth_number(strings,
  n = 1, decimals = TRUE, leading_decimals = TRUE,
  sci = TRUE
)
str_first_number(strings,
  decimals = TRUE, leading_decimals = TRUE,
  sci = TRUE, commas = TRUE, negs = TRUE
)
str_last_number(strings,
  decimals = TRUE, leading_decimals = FALSE,
  sci = FALSE, commas = TRUE, negs = TRUE, leave_as_string = TRUE
)
str_first_number(c("22", "1.2.3"), decimals = TRUE)
}
\seealso{
Other numeric extractors: 
\code{\link{str_extract_numbers}()},
\code{\link{str_nth_number_after_mth}()},
\code{\link{str_nth_number_before_mth}()}
}
\concept{numeric extractors}
