% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecxsys.R
\name{ecxsys}
\alias{ecxsys}
\title{ECx-SyS}
\usage{
ecxsys(
  concentration,
  hormesis_concentration,
  survival_tox_observed,
  survival_tox_env_observed = NULL,
  survival_max = 100,
  curves_concentration_max = NULL,
  p = 3.2,
  q = 3.2
)
}
\arguments{
\item{concentration}{A vector of concentrations. Must be sorted in ascending
order and the first element must be 0 to indicate the control.}

\item{hormesis_concentration}{The concentration where the hormesis occurs.
This is usually the concentration of the highest survival after the
control.}

\item{survival_tox_observed}{A vector of survival values observed at the given
concentrations and in absence of environmental stress. Values must be
between 0 and \code{survival_max}.}

\item{survival_tox_env_observed}{Survival values observed in the presence of
environmental stress. Must be between 0 and \code{survival_max}.}

\item{survival_max}{The maximum value the survival could possibly reach. For
survival data in percent this should be 100 (the default).}

\item{curves_concentration_max}{The maximum concentration of the predicted
curves. This might be useful if for example your highest observed
concentration is 30 but you would like to know the predicted values on a
scale between 0 and 100.}

\item{p, q}{The shape parameters of the beta distribution. Default is
\code{p = q = 3.2}.}
}
\value{
A list (of class ecxsys) containing many different objects of which
  the most important are listed below. The survival and stress vectors
  correspond to the provided concentrations.
  \describe{
    \item{survival_tox}{Modeled survival resulting from toxicant stress.}
    \item{survival_tox_sys}{Modeled survival resulting from toxicant and
    system stress.}
    \item{survival_tox_env}{Modeled survival resulting from toxicant and
    environmental stress.}
    \item{survival_tox_env_sys}{Modeled survival resulting from toxicant,
    environmental and system stress.}
    \item{survival_tox_LL5}{The survival predicted by the five-parameter
    log-logistic model derived from the observations under toxicant stress
    but without environmental stress.}
    \item{survival_tox_env_LL5}{The survival predicted by the five-parameter
    log-logistic model derived from the observations under toxicant stress
    with environmental stress.}
    \item{curves}{A data frame containing survival and stress values as
    returned by \code{\link{predict_ecxsys}}. The concentrations are
    regularly spaced on a logarithmic scale in the given concentration range.
    The control is approximated by the lowest non-control concentration times
    1e-7. The additional column \code{concentration_for_plots} is used by the
    plotting functions of this package to approximate the control and
    generate a nice concentration axis.}
  }
}
\description{
ECx-SyS is a model for tri-phasic concentration-response relationships where
hormetic and subhormetic effects are observed at low concentrations. It
expands the Stress Addition Model (SAM) by introducing system stress (SyS)
which is negatively correlated with toxicant stress. A constant environmental
stress can be included. See the publication for details.
}
\details{
It is advised to complete the curve down to zero for optimal prediction.
Therefore \code{survival_tox_observed} in the highest concentration should be
at or close to zero. If the model does not fit properly try adding a survival
of 0 at ten times the maximum observed concentration.

The vectors \code{concentration}, \code{survival_tox_observed} and
\code{survival_tox_env_observed} (if provided) must be of equal length and
sorted by increasing concentration.
}
\examples{
model <- ecxsys(
    concentration = c(0, 0.05, 0.5, 5, 30),
    hormesis_concentration = 0.5,
    survival_tox_observed = c(90, 81, 92, 28, 0),
    survival_tox_env_observed = c(29, 27, 33, 5, 0)
)

# Use survival_max if for example the survival is given as the average number
# of surviving animals and the initial number of animals is 21:
model <- ecxsys(
    concentration = c(0, 0.03, 0.3, 3, 30),
    hormesis_concentration = 0.3,
    survival_tox_observed = c(17, 15.2, 18.8, 7, 0),
    survival_tox_env_observed = c(4.8, 4.6, 6.4, 0, 0),
    survival_max = 21
)

}
\references{
\href{https://doi.org/10.1038/s41598-019-51645-4}{Liess, M.,
  Henz, S. & Knillmann, S. Predicting low-concentration effects of
  pesticides. Sci Rep 9, 15248 (2019).}
}
