% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{make_report_rmd}
\alias{make_report_rmd}
\title{Generate report(s) with modeling stats and survival estimates using pandoc.}
\usage{
make_report_rmd(OData, MSM, NPMSM, TMLE, GCOMP, wts_data, SurvByRegimen,
  WTtables = NULL, AddFUPtables = FALSE, MSM.RDtables, TMLE.RDtables,
  format = c("html", "pdf", "word"), skip.modelfits = FALSE,
  file.name = getOption("stremr.file.name"),
  file.path = getOption("stremr.file.path"), openFile = TRUE,
  keep_md = FALSE, keep_tex = FALSE, ...)
}
\arguments{
\item{OData}{Input data object returned by the function \code{\link{importData}}.}

\item{MSM}{The MSM object fits returned by the function \code{\link{survMSM}}.}

\item{NPMSM}{Optional list of a resulting calls to \code{survNPMSM} or a result of a single call to \code{\link{survNPMSM}}.}

\item{TMLE}{Optional list of a resulting calls to \code{fitTMLE} or a result of a single call to \code{\link{fitTMLE}}.}

\item{GCOMP}{Optional list of a resulting calls to \code{fitSeqGcomp} or a result of a single call to \code{\link{fitSeqGcomp}}.}

\item{wts_data}{Optional list of data.tables or a single data.table with weights by regimen.}

\item{SurvByRegimen}{... Not implemented ...}

\item{WTtables}{Table(s) with distribution(s) of the IPTW weights, a result of calling the function \code{\link{get_wtsummary}}}

\item{AddFUPtables}{Logical, set to \code{TRUE} to print tables describing the distribution of the maximum follow-up times
by rule (monitoring and treatment).}

\item{MSM.RDtables}{List of tables with risk differences returned by the function \code{\link{get_MSM_RDs}}.}

\item{TMLE.RDtables}{List of tables with risk differences returned by the function \code{\link{get_TMLE_RDs}}.}

\item{format}{Choose the Pandoc output format for the report file (html, pdf or word).
Note that the html report file is always produced in addition to any other selected format.}

\item{skip.modelfits}{Do not report any of the modeling stats.}

\item{file.name}{File name for the report file without extension. Default file name is assigned based on the current date.}

\item{file.path}{Directory path where the report file(s) should be written. Default is to use the system temporary directory.}

\item{openFile}{Open the report file with OS default viewer?}

\item{keep_md}{Keep the source .md files?}

\item{keep_tex}{Keep the source .tex files for pdf output?}

\item{...}{Additional arguments may specify the report title (\code{author}), author (\code{title}).
Specifying the logical flag \code{only.coefs=TRUE} disables printing of all h2o-specific model summaries.
Additional set of arguments control the survival plotting, these are passed on to the function \code{f_plot_survest}:
\code{t_int_sel}, \code{y_lab}, \code{x_lab}, \code{miny}, \code{x_legend}, \code{y_legend}.}
}
\value{
String specifying the path to the main report file.
}
\description{
Generate report(s) with modeling stats and survival estimates using pandoc.
}

