% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs_examples.r
\name{streambugs.example.model.extended}
\alias{streambugs.example.model.extended}
\title{Set-up the streambugs extended model}
\usage{
streambugs.example.model.extended()
}
\value{
List with:\describe{
   \item{\code{$name}}{name of the example}
   \item{\code{$y.names}}{list with names of state variables as returned by
     the \link{decode.statevarnames} function}
   \item{\code{$times}, \code{$par}, \code{$inp}:}{corresponding input
         parameters of the \code{\link{run.streambugs}} function}
   }
}
\description{
Set-up state variables, parameters, input, and output times of the streambugs
extended model. All these are defined and read from \code{.dat} files The model is
ready to run with \code{\link{run.streambugs}}.
}
\section{Model syntax}{

See "docs/Streambugs_syntax.pdf" file in the package installation folder:
\code{system.file("docs", "Streambugs_syntax.pdf", package="streambugs")}.
}

\examples{
model <- streambugs.example.model.extended()
# display values of microhabitat tolerance values for Lumbriculidae taxa
model$par[grepl("^Lumbriculidae_microhabtolval", names(model$par))]

}
