/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.oneclass;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.OneClassClassifier;
import moa.core.FixedLengthList;
import moa.core.Measurement;

public class NearestNeighbourDescription
extends AbstractClassifier
implements Classifier,
OneClassClassifier {
    private static final long serialVersionUID = 1L;
    public IntOption neighbourhoodSizeOption = new IntOption("neighbourhoodSize", 'n', "The number of instances to store in the neighbourhood.", 200, 1, Integer.MAX_VALUE);
    public FloatOption thresholdOption = new FloatOption("tau", 't', "The threshold value to determine whether an instance is a member of the target class or an outlier", 1.0);
    private int nbhdSize;
    private double tau;
    private FixedLengthList<Instance> neighbourhood;

    @Override
    public String getPurposeString() {
        return "NN-d is a nearest neighbour method for one-class classification.";
    }

    public NearestNeighbourDescription() {
    }

    public NearestNeighbourDescription(List<Instance> trainingSet) {
        this.resetLearningImpl();
        this.neighbourhood.addAll(trainingSet);
    }

    @Override
    public void resetLearningImpl() {
        this.nbhdSize = this.neighbourhoodSizeOption.getValue();
        this.tau = this.thresholdOption.getValue();
        this.neighbourhood = new FixedLengthList(this.nbhdSize);
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.getAnomalyScore(inst) < 0.5) {
            this.neighbourhood.add(inst);
        }
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double[] votes = new double[]{0.5, 0.5};
        if (this.neighbourhood.size() > 2) {
            votes[1] = Math.pow(2.0, -1.0 * this.getAnomalyScore(inst) / this.tau);
            votes[0] = 1.0 - votes[1];
        }
        return votes;
    }

    @Override
    public double getAnomalyScore(Instance inst) {
        if (this.neighbourhood.size() < 2) {
            return 1.0;
        }
        Instance nearestNeighbour = this.getNearestNeighbour(inst, this.neighbourhood, false);
        Instance nnNearestNeighbour = this.getNearestNeighbour(nearestNeighbour, this.neighbourhood, true);
        double indicatorArgument = this.distance(inst, nearestNeighbour) / this.distance(nearestNeighbour, nnNearestNeighbour);
        return indicatorArgument;
    }

    private Instance getNearestNeighbour(Instance inst, List<Instance> neighbourhood2, boolean inNbhd) {
        double dist = Double.MAX_VALUE;
        Instance nearestNeighbour = null;
        for (Instance candidateNN : neighbourhood2) {
            if (inNbhd && this.distance(inst, candidateNN) == 0.0) {
                inNbhd = false;
                continue;
            }
            if (!(this.distance(inst, candidateNN) < dist)) continue;
            nearestNeighbour = candidateNN.copy();
            dist = this.distance(inst, candidateNN);
        }
        return nearestNeighbour;
    }

    private double distance(Instance inst1, Instance inst2) {
        double dist = 0.0;
        for (int i = 0; i < inst1.numAttributes(); ++i) {
            dist += Math.pow(inst1.value(i) - inst2.value(i), 2.0);
        }
        return Math.sqrt(dist);
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public void initialize(Collection<Instance> trainingPoints) {
        Iterator<Instance> trgPtsIterator = trainingPoints.iterator();
        if (trgPtsIterator.hasNext()) {
            this.trainOnInstance(trgPtsIterator.next());
        }
    }
}

