/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.kmeanspm;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import moa.clusterers.kmeanspm.DietzfelbingerHash;

public class CuckooHashing<T> {
    public static final int DEFAULT_STASH_SIZE = 10;
    public static final int DEFAULT_NUM_TABLES = 2;
    private final int startHashSize;
    private final int maxStashSize;
    private final int startNumTables;
    private Random random;
    private int hashSize;
    private List<DietzfelbingerHash> hashfunctions;
    private List<Entry<T>> elements;
    private int numElements;
    private List<List<Entry<T>>> tables;
    private int numTables;
    private List<Entry<T>> stash;
    private int stashSize;

    public CuckooHashing(int startHashSize, int maxStashSize, int startNumTables, Random random) {
        assert (startHashSize < 31);
        this.startHashSize = startHashSize;
        this.maxStashSize = maxStashSize;
        this.startNumTables = startNumTables;
        this.random = random;
        this.hashSize = startHashSize;
        int sizeTables = 1 << startHashSize;
        this.hashfunctions = new ArrayList<DietzfelbingerHash>(startNumTables);
        this.elements = new ArrayList<Entry<T>>(sizeTables);
        this.numElements = 0;
        this.tables = new ArrayList<List<Entry<T>>>(startNumTables);
        this.numTables = startNumTables;
        this.stash = new ArrayList<Entry<T>>();
        this.stashSize = 0;
        for (int i = 0; i < startNumTables; ++i) {
            this.hashfunctions.add(new DietzfelbingerHash(startHashSize, random));
            ArrayList<Object> table = new ArrayList<Object>(sizeTables);
            for (int j = 0; j < sizeTables; ++j) {
                table.add(null);
            }
            this.tables.add(table);
        }
    }

    public CuckooHashing(int hashSize, Random random) {
        this(hashSize, 10, 2, random);
    }

    public void put(long key, T element) {
        Entry<T> entry = new Entry<T>(key, element);
        this.elements.add(entry);
        ++this.numElements;
        this.fileElement(entry, true);
    }

    private void fileElement(Entry<T> currentElement, boolean rehash) {
        int maxFailures = Math.max((int)Math.log(this.numElements), this.numTables * 2);
        int currentTable = 0;
        for (int i = 0; i < maxFailures; ++i) {
            int hash = this.hashfunctions.get(currentTable).hash(currentElement.getKey());
            currentElement = this.tables.get(currentTable).set(hash, currentElement);
            if (currentElement == null) break;
            currentTable = (currentTable + 1) % this.numTables;
        }
        if (currentElement != null) {
            this.stash.add(currentElement);
            ++this.stashSize;
        }
        while (rehash && this.stashSize > this.maxStashSize) {
            this.reset();
            if (this.stashSize <= this.maxStashSize) continue;
            this.increaseAndReset();
        }
    }

    private void increaseAndReset() {
        if (this.hashSize < 30) {
            ++this.hashSize;
            this.hashfunctions.clear();
            for (List<Entry<T>> table : this.tables) {
                this.hashfunctions.add(new DietzfelbingerHash(this.hashSize, this.random));
                ((ArrayList)table).ensureCapacity(1 << this.hashSize);
            }
        } else {
            this.hashfunctions.add(new DietzfelbingerHash(this.hashSize, this.random));
            this.tables.add(new ArrayList(1 << this.hashSize));
            ++this.numTables;
        }
        this.reset();
    }

    public T get(long key) {
        for (int i = 0; i < this.numTables; ++i) {
            Entry<T> entry = this.tables.get(i).get(this.hashfunctions.get(i).hash(key));
            if (entry == null || entry.getKey() != key) continue;
            return entry.getValue();
        }
        for (Entry<T> entry : this.stash) {
            if (entry.getKey() != key) continue;
            return entry.getValue();
        }
        return null;
    }

    private void reset() {
        for (DietzfelbingerHash hashfunction : this.hashfunctions) {
            hashfunction.nextHashFunction();
        }
        int sizeTables = 1 << this.hashSize;
        for (List<Entry<T>> list : this.tables) {
            list.clear();
            for (int j = 0; j < sizeTables; ++j) {
                list.add(null);
            }
        }
        this.stash.clear();
        this.stashSize = 0;
        for (Entry entry : this.elements) {
            this.fileElement(entry, false);
        }
    }

    public void clear() {
        this.hashSize = this.startHashSize;
        this.numTables = this.startNumTables;
        this.numElements = 0;
        this.hashfunctions.clear();
        this.tables.clear();
        int sizeTables = 1 << this.startHashSize;
        for (int i = 0; i < this.startNumTables; ++i) {
            this.hashfunctions.add(new DietzfelbingerHash(this.startHashSize, this.random));
            ArrayList<Object> table = new ArrayList<Object>(sizeTables);
            for (int j = 0; j < sizeTables; ++j) {
                table.add(null);
            }
            this.tables.add(table);
        }
        this.stash.clear();
        this.stashSize = 0;
    }

    public int size() {
        return this.numElements;
    }

    public boolean isEmpty() {
        return this.numElements == 0;
    }

    private class Entry<V> {
        private final long key;
        private final V value;

        public Entry(long key, V value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

