/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Random;
import moa.core.FastVector;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class SEAGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public IntOption functionOption = new IntOption("function", 'f', "Classification function used, as defined in the original paper.", 1, 1, 4);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public FlagOption balanceClassesOption = new FlagOption("balanceClasses", 'b', "Balance the number of instances of each class.");
    public IntOption numInstancesConcept = new IntOption("numInstancesConcept", 'n', "The number of instances for each concept.", 0, 0, Integer.MAX_VALUE);
    public IntOption noisePercentageOption = new IntOption("noisePercentage", 'p', "Percentage of noise to add to the data.", 10, 0, 100);
    protected static ClassFunction[] classificationFunctions = new ClassFunction[]{new ClassFunction(){

        @Override
        public int determineClass(double attrib1, double attrib2, double attrib3) {
            return attrib1 + attrib2 <= 8.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(double attrib1, double attrib2, double attrib3) {
            return attrib1 + attrib2 <= 9.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(double attrib1, double attrib2, double attrib3) {
            return attrib1 + attrib2 <= 7.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(double attrib1, double attrib2, double attrib3) {
            return attrib1 + attrib2 <= 9.5 ? 0 : 1;
        }
    }};
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected boolean nextClassShouldBeZero;

    @Override
    public String getPurposeString() {
        return "Generates SEA concepts functions.";
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        attributes.addElement(new Attribute("attrib1"));
        attributes.addElement(new Attribute("attrib2"));
        attributes.addElement(new Attribute("attrib3"));
        FastVector<String> classLabels = new FastVector<String>();
        classLabels.addElement("groupA");
        classLabels.addElement("groupB");
        attributes.addElement(new Attribute("class", classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public InstanceExample nextInstance() {
        double attrib1 = 0.0;
        double attrib2 = 0.0;
        double attrib3 = 0.0;
        int group = 0;
        boolean desiredClassFound = false;
        while (!desiredClassFound) {
            attrib1 = 10.0 * this.instanceRandom.nextDouble();
            attrib2 = 10.0 * this.instanceRandom.nextDouble();
            attrib3 = 10.0 * this.instanceRandom.nextDouble();
            group = classificationFunctions[this.functionOption.getValue() - 1].determineClass(attrib1, attrib2, attrib3);
            if (!this.balanceClassesOption.isSet()) {
                desiredClassFound = true;
                continue;
            }
            if ((!this.nextClassShouldBeZero || group != 0) && (this.nextClassShouldBeZero || group != 1)) continue;
            desiredClassFound = true;
            this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
        }
        if (1 + this.instanceRandom.nextInt(100) <= this.noisePercentageOption.getValue()) {
            group = group == 0 ? 1 : 0;
        }
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance((double)header.numAttributes());
        inst.setValue(0, attrib1);
        inst.setValue(1, attrib2);
        inst.setValue(2, attrib3);
        inst.setDataset(header);
        inst.setClassValue(group);
        return new InstanceExample(inst);
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.nextClassShouldBeZero = false;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    protected static interface ClassFunction {
        public int determineClass(double var1, double var3, double var5);
    }
}

