/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.SparseInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;

public class WekaToSamoaInstanceConverter
implements Serializable {
    protected Instances samoaInstanceInformation;

    public Instance samoaInstance(weka.core.Instance inst) {
        InstanceImpl samoaInstance;
        if (inst instanceof weka.core.SparseInstance) {
            double[] attributeValues = new double[inst.numValues()];
            int[] indexValues = new int[inst.numValues()];
            for (int i = 0; i < inst.numValues(); ++i) {
                if (inst.index(i) == inst.classIndex()) continue;
                attributeValues[i] = inst.valueSparse(i);
                indexValues[i] = inst.index(i);
            }
            samoaInstance = new SparseInstance(inst.weight(), attributeValues, indexValues, inst.numAttributes());
        } else {
            samoaInstance = new DenseInstance(inst.weight(), inst.toDoubleArray());
        }
        if (this.samoaInstanceInformation == null) {
            this.samoaInstanceInformation = this.samoaInstancesInformation(inst.dataset());
        }
        samoaInstance.setDataset(this.samoaInstanceInformation);
        samoaInstance.setClassValue(inst.classValue());
        return samoaInstance;
    }

    public Instances samoaInstances(weka.core.Instances instances) {
        Instances samoaInstances;
        this.samoaInstanceInformation = samoaInstances = this.samoaInstancesInformation(instances);
        for (int i = 0; i < instances.numInstances(); ++i) {
            samoaInstances.add(this.samoaInstance(instances.instance(i)));
        }
        return samoaInstances;
    }

    public Instances samoaInstancesInformation(weka.core.Instances instances) {
        ArrayList<Attribute> attInfo = new ArrayList<Attribute>();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            attInfo.add(this.samoaAttribute(i, instances.attribute(i)));
        }
        Instances samoaInstances = new Instances(instances.relationName(), attInfo, 0);
        samoaInstances.setClassIndex(instances.classIndex());
        return samoaInstances;
    }

    protected Attribute samoaAttribute(int index, weka.core.Attribute attribute) {
        Attribute samoaAttribute;
        if (attribute.isNominal()) {
            Enumeration enu = attribute.enumerateValues();
            ArrayList<String> attributeValues = new ArrayList<String>();
            while (enu.hasMoreElements()) {
                attributeValues.add((String)enu.nextElement());
            }
            samoaAttribute = new Attribute(attribute.name(), attributeValues);
        } else {
            samoaAttribute = new Attribute(attribute.name());
        }
        return samoaAttribute;
    }
}

