/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks.meta;

import java.util.List;
import moa.core.ObjectRepository;
import moa.core.TimingUtils;
import moa.tasks.FailedTaskReport;
import moa.tasks.Task;
import moa.tasks.TaskThread;
import moa.tasks.meta.ALMainTask;

public class ALTaskThread
extends TaskThread {
    public ALTaskThread(Task toRun) {
        super(toRun, null);
    }

    public ALTaskThread(Task toRun, ObjectRepository repository) {
        super(toRun, repository);
    }

    @Override
    public synchronized void pauseTask() {
        ALMainTask task = (ALMainTask)this.getTask();
        List<ALTaskThread> threads = task.getSubtaskThreads();
        super.pauseTask();
        for (int i = 0; i < threads.size(); ++i) {
            threads.get(i).pauseTask();
        }
    }

    @Override
    public synchronized void resumeTask() {
        ALMainTask task = (ALMainTask)this.getTask();
        List<ALTaskThread> threads = task.getSubtaskThreads();
        super.resumeTask();
        for (int i = 0; i < threads.size(); ++i) {
            threads.get(i).resumeTask();
        }
    }

    @Override
    public synchronized void cancelTask() {
        ALMainTask task = (ALMainTask)this.getTask();
        List<ALTaskThread> threads = task.getSubtaskThreads();
        super.cancelTask();
        if (!this.failed()) {
            this.finalResult = this.getLatestResultPreview();
        }
        for (int i = 0; i < threads.size(); ++i) {
            if (threads.get(i).isComplete()) continue;
            threads.get(i).cancelTask();
        }
    }

    public boolean failed() {
        return this.currentStatus == TaskThread.Status.FAILED;
    }

    public boolean cancelled() {
        return this.currentStatus == TaskThread.Status.CANCELLED;
    }

    @Override
    public void run() {
        TimingUtils.enablePreciseTiming();
        this.taskStartTime = TimingUtils.getNanoCPUTimeOfThread(this.getId());
        try {
            this.currentStatus = TaskThread.Status.RUNNING;
            this.finalResult = this.runningTask.doTask(this.taskMonitor, this.repository);
            this.currentStatus = this.taskMonitor.isCancelled() ? TaskThread.Status.CANCELLED : TaskThread.Status.COMPLETED;
        }
        catch (Throwable ex) {
            this.finalResult = new FailedTaskReport(ex);
            this.currentStatus = TaskThread.Status.FAILED;
        }
        if (this.currentStatus == TaskThread.Status.FAILED || this.currentStatus == TaskThread.Status.CANCELLED) {
            this.cancelTask();
        }
        this.taskEndTime = TimingUtils.getNanoCPUTimeOfThread(this.getId());
        this.fireTaskCompleted();
        this.taskMonitor.setLatestResultPreview(null);
    }
}

