/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.outliertab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import moa.gui.FileExtensionFilter;
import moa.gui.outliertab.OutlierSetupTab;
import moa.gui.outliertab.OutlierVisualEvalPanel;
import moa.gui.visualization.GraphCanvas;
import moa.gui.visualization.RunOutlierVisualizer;
import moa.gui.visualization.StreamOutlierPanel;

public class OutlierVisualTab
extends JPanel
implements ActionListener,
ComponentListener {
    private RunOutlierVisualizer visualizer = null;
    private Thread visualizerThread = null;
    private Boolean running = false;
    private OutlierSetupTab outlierSetupTab = null;
    private String exportFile;
    private String screenshotFilebase;
    private JButton buttonRun;
    private JButton buttonScreenshot;
    private JButton buttonRedraw;
    private JButton buttonStop;
    private JButton buttonZoomInX;
    private JButton buttonZoomInY;
    private JButton buttonZoomOutX;
    private JButton buttonZoomOutY;
    private JCheckBox checkboxDrawOutliers;
    private JCheckBox checkboxDrawPoints;
    private JCheckBox checkboxWaitWinFull;
    private JComboBox comboX;
    private JComboBox comboY;
    private GraphCanvas graphCanvas;
    private JPanel graphPanel;
    private JPanel graphPanelControlBottom;
    private JPanel graphPanelControlTop;
    private JScrollPane graphScrollPanel;
    private JLabel jLabel1;
    private JSplitPane jSplitPane1;
    private JLabel labelEvents;
    private JLabel labelNumPause;
    private JLabel labelX;
    private JLabel labelY;
    private JLabel label_processed_points;
    private JLabel label_processed_points_value;
    private JTextField numPauseAfterPoints;
    private JPanel panelControl;
    private JPanel panelEvalOutput;
    private JPanel panelVisualWrapper;
    private JScrollPane scrollPane0;
    private JScrollPane scrollPane1;
    private JSlider speedSlider;
    private JSplitPane splitVisual;
    private StreamOutlierPanel streamPanel0;
    private StreamOutlierPanel streamPanel1;
    private JPanel topWrapper;

    public OutlierVisualTab() {
        this.resetComponents();
    }

    private void resetComponents() {
        this.initComponents();
        this.comboY.setSelectedIndex(1);
        this.graphCanvas.setViewport(this.graphScrollPanel.getViewport());
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        ToolTipManager.sharedInstance().setInitialDelay(100);
    }

    public void setOutlierSetupTab(OutlierSetupTab outlierSetupTab) {
        this.outlierSetupTab = outlierSetupTab;
    }

    private void createVisualiterThread() {
        this.visualizer = new RunOutlierVisualizer(this, this.outlierSetupTab);
        this.visualizerThread = new Thread(this.visualizer);
    }

    public void setDimensionComobBoxes(int numDimensions) {
        String[] dimensions = new String[numDimensions];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = "Dim " + (i + 1);
        }
        this.comboX.setModel(new DefaultComboBoxModel<String>(dimensions));
        this.comboY.setModel(new DefaultComboBoxModel<String>(dimensions));
        this.comboY.setSelectedIndex(1);
    }

    public StreamOutlierPanel getLeftStreamPanel() {
        return this.streamPanel0;
    }

    public StreamOutlierPanel getRightStreamPanel() {
        return this.streamPanel1;
    }

    public GraphCanvas getGraphCanvas() {
        return this.graphCanvas;
    }

    public OutlierVisualEvalPanel getEvalPanel() {
        return null;
    }

    public boolean isEnabledDrawPoints() {
        return this.checkboxDrawPoints.isSelected();
    }

    public boolean isEnabledDrawOutliers() {
        return this.checkboxDrawOutliers.isSelected();
    }

    public void setProcessedPointsCounter(int value) {
        this.label_processed_points_value.setText(Integer.toString(value));
    }

    public int getPauseInterval() {
        return Integer.parseInt(this.numPauseAfterPoints.getText());
    }

    public void setPauseInterval(int pause) {
        this.numPauseAfterPoints.setText(Integer.toString(pause));
    }

    private void UpdateSplitVisualDivider() {
        if (this.splitVisual != null) {
            this.splitVisual.setDividerLocation(this.splitVisual.getWidth() / 2);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        this.UpdateSplitVisualDivider();
    }

    @Override
    public void componentResized(ComponentEvent ce) {
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
    }

    @Override
    public void componentShown(ComponentEvent ce) {
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
    }

    public void toggleVisualizer(boolean internal) {
        if (this.visualizer == null) {
            this.createVisualiterThread();
        }
        if (!this.visualizerThread.isAlive()) {
            this.visualizerThread.start();
        }
        if (this.running.booleanValue()) {
            this.running = false;
            OutlierVisualTab outlierVisualTab = this;
            outlierVisualTab.visualizer.pause();
            this.buttonRun.setText("Resume");
        } else {
            this.running = true;
            OutlierVisualTab outlierVisualTab = this;
            outlierVisualTab.visualizer.resume();
            this.buttonRun.setText("Pause");
        }
        if (internal) {
            this.outlierSetupTab.toggleRunMode();
        }
    }

    public void stopVisualizer() {
        if (this.visualizer == null) {
            return;
        }
        this.visualizer.stop();
        this.running = false;
        this.visualizer = null;
        this.visualizerThread = null;
        this.removeAll();
        this.resetComponents();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.topWrapper = new JPanel();
        this.panelVisualWrapper = new JPanel();
        this.splitVisual = new JSplitPane();
        this.scrollPane1 = new JScrollPane();
        this.scrollPane0 = new JScrollPane();
        this.streamPanel0 = new StreamOutlierPanel(Color.RED);
        this.streamPanel1 = new StreamOutlierPanel(Color.BLUE);
        this.panelControl = new JPanel();
        this.buttonRun = new JButton();
        this.buttonStop = new JButton();
        this.buttonRedraw = new JButton();
        this.buttonScreenshot = new JButton();
        this.speedSlider = new JSlider();
        this.jLabel1 = new JLabel();
        this.comboX = new JComboBox();
        this.labelX = new JLabel();
        this.comboY = new JComboBox();
        this.labelY = new JLabel();
        this.checkboxDrawPoints = new JCheckBox();
        this.checkboxDrawOutliers = new JCheckBox();
        this.checkboxWaitWinFull = new JCheckBox();
        this.label_processed_points = new JLabel();
        this.label_processed_points_value = new JLabel();
        this.labelNumPause = new JLabel();
        this.numPauseAfterPoints = new JTextField();
        this.panelEvalOutput = new JPanel();
        this.graphPanel = new JPanel();
        this.graphPanelControlTop = new JPanel();
        this.buttonZoomInY = new JButton();
        this.buttonZoomOutY = new JButton();
        this.labelEvents = new JLabel();
        this.graphScrollPanel = new JScrollPane();
        this.graphCanvas = new GraphCanvas();
        this.graphPanelControlBottom = new JPanel();
        this.buttonZoomInX = new JButton();
        this.buttonZoomOutX = new JButton();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOrientation(0);
        this.topWrapper.setPreferredSize(new Dimension(688, 500));
        this.topWrapper.setLayout(new GridBagLayout());
        this.panelVisualWrapper.setLayout(new BorderLayout());
        this.splitVisual.setDividerLocation(400);
        this.splitVisual.setResizeWeight(1.0);
        this.scrollPane0.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                OutlierVisualTab.this.scrollPane0MouseWheelMoved(evt);
            }
        });
        this.streamPanel1.setPreferredSize(new Dimension(400, 250));
        GroupLayout streamPanel1Layout = new GroupLayout(this.streamPanel1);
        this.streamPanel1.setLayout(streamPanel1Layout);
        streamPanel1Layout.setHorizontalGroup(streamPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 428, Short.MAX_VALUE));
        streamPanel1Layout.setVerticalGroup(streamPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 339, Short.MAX_VALUE));
        this.scrollPane1.setViewportView(this.streamPanel1);
        this.splitVisual.setRightComponent(this.scrollPane1);
        this.scrollPane0.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                OutlierVisualTab.this.scrollPane0MouseWheelMoved(evt);
            }
        });
        this.streamPanel0.setPreferredSize(new Dimension(400, 250));
        GroupLayout streamPanel0Layout = new GroupLayout(this.streamPanel0);
        this.streamPanel0.setLayout(streamPanel0Layout);
        streamPanel0Layout.setHorizontalGroup(streamPanel0Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        streamPanel0Layout.setVerticalGroup(streamPanel0Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 339, Short.MAX_VALUE));
        this.scrollPane0.setViewportView(this.streamPanel0);
        this.splitVisual.setLeftComponent(this.scrollPane0);
        this.splitVisual.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent ce) {
                OutlierVisualTab.this.UpdateSplitVisualDivider();
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
            }

            @Override
            public void componentShown(ComponentEvent ce) {
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
            }
        });
        this.panelVisualWrapper.add((Component)this.splitVisual, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 400;
        gridBagConstraints.ipady = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.topWrapper.add((Component)this.panelVisualWrapper, gridBagConstraints);
        this.panelControl.setMinimumSize(new Dimension(600, 76));
        this.panelControl.setPreferredSize(new Dimension(2000, 76));
        this.panelControl.setLayout(new GridBagLayout());
        int iBtnHeight = 27;
        int iInsetW = 2;
        int iInsetH = 2;
        this.buttonRun.setText("Start");
        this.buttonRun.setMinimumSize(new Dimension(90, iBtnHeight));
        this.buttonRun.setPreferredSize(new Dimension(90, iBtnHeight));
        this.buttonRun.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OutlierVisualTab.this.buttonRunMouseClicked(evt);
            }
        });
        this.buttonRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.buttonRunActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(iInsetW, iInsetH, iInsetW, iInsetH);
        this.panelControl.add((Component)this.buttonRun, gridBagConstraints);
        this.buttonStop.setText("Stop");
        this.buttonStop.setMinimumSize(new Dimension(90, iBtnHeight));
        this.buttonStop.setPreferredSize(new Dimension(90, iBtnHeight));
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.buttonStopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(iInsetW, iInsetH, iInsetW, iInsetH);
        this.panelControl.add((Component)this.buttonStop, gridBagConstraints);
        this.buttonRedraw.setText("Redraw");
        this.buttonRedraw.setMinimumSize(new Dimension(100, iBtnHeight));
        this.buttonRedraw.setPreferredSize(new Dimension(100, iBtnHeight));
        this.buttonRedraw.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OutlierVisualTab.this.buttonRedrawMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(iInsetW, iInsetH, iInsetW, iInsetH);
        this.panelControl.add((Component)this.buttonRedraw, gridBagConstraints);
        this.buttonScreenshot.setText("Screenshot");
        this.buttonScreenshot.setMinimumSize(new Dimension(100, iBtnHeight));
        this.buttonScreenshot.setPreferredSize(new Dimension(100, iBtnHeight));
        this.buttonScreenshot.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OutlierVisualTab.this.buttonScreenshotMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(iInsetW, iInsetH, iInsetW, iInsetH);
        this.panelControl.add((Component)this.buttonScreenshot, gridBagConstraints);
        this.speedSlider.setValue(100);
        this.speedSlider.setBorder(BorderFactory.createTitledBorder("Visualisation Speed"));
        this.speedSlider.setMinimumSize(new Dimension(160, 68));
        this.speedSlider.setPreferredSize(new Dimension(170, 68));
        this.speedSlider.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                OutlierVisualTab.this.speedSliderMouseDragged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 16, 1, 5);
        this.panelControl.add((Component)this.speedSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelControl.add((Component)this.jLabel1, gridBagConstraints);
        this.comboX.setModel(new DefaultComboBoxModel<String>(new String[]{"Dim 1", "Dim 2", "Dim 3", "Dim 4"}));
        this.comboX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.comboXActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelControl.add((Component)this.comboX, gridBagConstraints);
        this.labelX.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 14, 0, 5);
        this.panelControl.add((Component)this.labelX, gridBagConstraints);
        this.comboY.setModel(new DefaultComboBoxModel<String>(new String[]{"Dim 1", "Dim 2", "Dim 3", "Dim 4"}));
        this.comboY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.comboYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelControl.add((Component)this.comboY, gridBagConstraints);
        this.labelY.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 14, 0, 5);
        this.panelControl.add((Component)this.labelY, gridBagConstraints);
        this.checkboxDrawPoints.setSelected(true);
        this.checkboxDrawPoints.setText("Points");
        this.checkboxDrawPoints.setMargin(new Insets(0, 0, 0, 0));
        this.checkboxDrawPoints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.checkboxDrawPointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelControl.add((Component)this.checkboxDrawPoints, gridBagConstraints);
        this.checkboxDrawOutliers.setSelected(true);
        this.checkboxDrawOutliers.setText("Outliers");
        this.checkboxDrawOutliers.setMargin(new Insets(0, 0, 0, 0));
        this.checkboxDrawOutliers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.checkboxDrawOutlierActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelControl.add((Component)this.checkboxDrawOutliers, gridBagConstraints);
        this.checkboxWaitWinFull.setSelected(true);
        this.checkboxWaitWinFull.setText("WaitWinFull");
        this.checkboxWaitWinFull.setMargin(new Insets(0, 0, 0, 0));
        this.checkboxWaitWinFull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.checkboxWaitWinFullActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.panelControl.add((Component)this.checkboxWaitWinFull, gridBagConstraints);
        this.label_processed_points.setText("Processed:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.panelControl.add((Component)this.label_processed_points, gridBagConstraints);
        this.label_processed_points_value.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelControl.add((Component)this.label_processed_points_value, gridBagConstraints);
        this.labelNumPause.setText("Pause in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.panelControl.add((Component)this.labelNumPause, gridBagConstraints);
        this.numPauseAfterPoints.setHorizontalAlignment(4);
        this.numPauseAfterPoints.setText(Integer.toString(1000));
        this.numPauseAfterPoints.setMinimumSize(new Dimension(70, 25));
        this.numPauseAfterPoints.setPreferredSize(new Dimension(70, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelControl.add((Component)this.numPauseAfterPoints, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.topWrapper.add((Component)this.panelControl, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.topWrapper);
        this.panelEvalOutput.setBorder(BorderFactory.createTitledBorder("Evaluation"));
        this.panelEvalOutput.setLayout(new GridBagLayout());
        this.graphPanel.setBorder(BorderFactory.createTitledBorder("Process time per object"));
        this.graphPanel.setPreferredSize(new Dimension(530, 115));
        this.graphPanel.setLayout(new GridBagLayout());
        this.graphPanelControlTop.setLayout(new GridBagLayout());
        this.buttonZoomInY.setText("Zoom in Y");
        this.buttonZoomInY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.buttonZoomInYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.buttonZoomInY, gridBagConstraints);
        this.buttonZoomOutY.setText("Zoom out Y");
        this.buttonZoomOutY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.buttonZoomOutYActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.buttonZoomOutY, gridBagConstraints);
        this.labelEvents.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlTop.add((Component)this.labelEvents, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.graphPanel.add((Component)this.graphPanelControlTop, gridBagConstraints);
        this.graphCanvas.setPreferredSize(new Dimension(500, 111));
        GroupLayout graphCanvasLayout = new GroupLayout(this.graphCanvas);
        this.graphCanvas.setLayout(graphCanvasLayout);
        graphCanvasLayout.setHorizontalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 515, Short.MAX_VALUE));
        graphCanvasLayout.setVerticalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        this.graphScrollPanel.setViewportView(this.graphCanvas);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.graphPanel.add((Component)this.graphScrollPanel, gridBagConstraints);
        this.buttonZoomInX.setText("Zoom in X");
        this.buttonZoomInX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.buttonZoomInXActionPerformed(evt);
            }
        });
        this.graphPanelControlBottom.add(this.buttonZoomInX);
        this.buttonZoomOutX.setText("Zoom out X");
        this.buttonZoomOutX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierVisualTab.this.buttonZoomOutXActionPerformed(evt);
            }
        });
        this.graphPanelControlBottom.add(this.buttonZoomOutX);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.graphPanel.add((Component)this.graphPanelControlBottom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.panelEvalOutput.add((Component)this.graphPanel, gridBagConstraints);
        this.panelEvalOutput.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent ce) {
                OutlierVisualTab.this.graphCanvas.updateCanvas(true);
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
            }

            @Override
            public void componentShown(ComponentEvent ce) {
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
            }
        });
        this.jSplitPane1.setRightComponent(this.panelEvalOutput);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void buttonRedrawMouseClicked(MouseEvent evt) {
        if (this.visualizer != null) {
            this.visualizer.redraw();
        }
    }

    private void buttonScreenshotMouseClicked(MouseEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (this.screenshotFilebase != null) {
            fileChooser.setSelectedFile(new File(this.screenshotFilebase));
        }
        if (fileChooser.showSaveDialog(this) == 0) {
            this.screenshotFilebase = fileChooser.getSelectedFile().getPath();
            this.streamPanel0.screenshot(this.screenshotFilebase + "_" + this.label_processed_points_value.getText() + "_0", true, true);
        }
    }

    private void buttonRunMouseClicked(MouseEvent evt) {
        this.toggleVisualizer(true);
    }

    private void speedSliderMouseDragged(MouseEvent evt) {
        if (this.speedSlider == null) {
            return;
        }
        if (this.visualizer == null) {
            return;
        }
        this.visualizer.setSpeed(this.speedSlider.getValue());
    }

    public int GetSpeed() {
        return this.speedSlider.getValue();
    }

    private void scrollPane0MouseWheelMoved(MouseWheelEvent evt) {
        this.streamPanel0.setZoom(evt.getX(), evt.getY(), -1 * evt.getWheelRotation(), this.scrollPane0);
    }

    private void buttonZoomInXActionPerformed(ActionEvent evt) {
        this.graphCanvas.scaleXResolution(false);
        this.graphCanvas.updateCanvas(true);
    }

    private void buttonZoomOutYActionPerformed(ActionEvent evt) {
        this.graphCanvas.setSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 0.8)));
        this.graphCanvas.setPreferredSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 0.8)));
        this.graphCanvas.updateCanvas(true);
    }

    private void buttonZoomOutXActionPerformed(ActionEvent evt) {
        this.graphCanvas.scaleXResolution(true);
        this.graphCanvas.updateCanvas(true);
    }

    private void buttonZoomInYActionPerformed(ActionEvent evt) {
        this.graphCanvas.setSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 1.2)));
        this.graphCanvas.setPreferredSize(new Dimension(this.graphCanvas.getWidth(), (int)((double)this.graphCanvas.getHeight() * 1.2)));
        this.graphCanvas.updateCanvas(true);
    }

    public boolean getPointVisibility() {
        return this.checkboxDrawPoints.isSelected();
    }

    public boolean getOutliersVisibility() {
        return this.checkboxDrawOutliers.isSelected();
    }

    private void checkboxDrawPointsActionPerformed(ActionEvent evt) {
        if (this.visualizer == null) {
            return;
        }
        this.visualizer.setPointsVisibility(this.checkboxDrawPoints.isSelected());
    }

    private void checkboxDrawOutlierActionPerformed(ActionEvent evt) {
        if (this.visualizer == null) {
            return;
        }
        if (this.running.booleanValue()) {
            return;
        }
        this.visualizer.setOutliersVisibility(this.checkboxDrawOutliers.isSelected());
    }

    public boolean getWaitWinFull() {
        return this.checkboxWaitWinFull.isSelected();
    }

    private void checkboxWaitWinFullActionPerformed(ActionEvent evt) {
        if (this.visualizer == null) {
            return;
        }
        this.visualizer.setWaitWinFull(this.checkboxWaitWinFull.isSelected());
    }

    private void comboXActionPerformed(ActionEvent evt) {
        if (this.visualizer == null) {
            return;
        }
        JComboBox cb = (JComboBox)evt.getSource();
        int dim = cb.getSelectedIndex();
        this.streamPanel0.setActiveXDim(dim);
        this.streamPanel1.setActiveXDim(dim);
        if (this.visualizer != null) {
            this.visualizer.redraw();
        }
    }

    private void comboYActionPerformed(ActionEvent evt) {
        if (this.visualizer == null) {
            return;
        }
        JComboBox cb = (JComboBox)evt.getSource();
        int dim = cb.getSelectedIndex();
        this.streamPanel0.setActiveYDim(dim);
        this.streamPanel1.setActiveYDim(dim);
        if (this.visualizer != null) {
            this.visualizer.redraw();
        }
    }

    private void buttonStopActionPerformed(ActionEvent evt) {
        this.stopVisualizer();
        this.outlierSetupTab.stopRun();
    }

    private void buttonRunActionPerformed(ActionEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.visualizer == null) {
            return;
        }
        if (e.getSource() instanceof JButton) {
            if (e.getActionCommand().equals("csv export")) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setAcceptAllFileFilterUsed(true);
                fileChooser.addChoosableFileFilter(new FileExtensionFilter("csv"));
                if (this.exportFile != null) {
                    fileChooser.setSelectedFile(new File(this.exportFile));
                }
                if (fileChooser.showSaveDialog(this) == 0) {
                    this.exportFile = fileChooser.getSelectedFile().getPath();
                    this.visualizer.exportCSV(this.exportFile);
                }
            }
            if (e.getActionCommand().equals("weka export")) {
                this.visualizer.weka();
            }
        }
    }
}

