/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;

public class C45Saver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter,
OptionHandler {
    static final long serialVersionUID = -821428878384253377L;

    public C45Saver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in the format used by the C4.5 algorithm.\nTherefore it outputs a names and a data file.";
    }

    @Override
    public String getFileDescription() {
        return "C4.5 file format";
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".names");
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        PrintWriter outW = null;
        if (structure != null) {
            if (structure.classIndex() == -1) {
                structure.setClassIndex(structure.numAttributes() - 1);
                System.err.println("No class specified. Last attribute is used as class attribute.");
            }
            if (structure.attribute(structure.classIndex()).isNumeric()) {
                throw new IOException("To save in C4.5 format the class attribute cannot be numeric.");
            }
        }
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.retrieveFile() == null || this.getWriter() == null) {
            throw new IOException("C4.5 format requires two files. Therefore no output to standard out can be generated.\nPlease specifiy output files using the -o option.");
        }
        outW = new PrintWriter(this.getWriter());
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            if (outW != null) {
                outW.close();
            }
            this.cancel();
        }
        if (writeMode == 3) {
            int i;
            this.setWriteMode(0);
            for (i = 0; i < structure.attribute(structure.classIndex()).numValues(); ++i) {
                outW.write(structure.attribute(structure.classIndex()).value(i));
                if (i < structure.attribute(structure.classIndex()).numValues() - 1) {
                    outW.write(",");
                    continue;
                }
                outW.write(".\n");
            }
            for (i = 0; i < structure.numAttributes(); ++i) {
                if (i == structure.classIndex()) continue;
                outW.write(structure.attribute(i).name() + ": ");
                if (structure.attribute(i).isNumeric() || structure.attribute(i).isDate()) {
                    outW.write("continuous.\n");
                    continue;
                }
                Attribute temp = structure.attribute(i);
                for (int j = 0; j < temp.numValues(); ++j) {
                    outW.write(temp.value(j));
                    if (j < temp.numValues() - 1) {
                        outW.write(",");
                        continue;
                    }
                    outW.write(".\n");
                }
            }
            outW.flush();
            outW.close();
            writeMode = this.getWriteMode();
            String out = this.retrieveFile().getAbsolutePath();
            this.setFileExtension(".data");
            out = out.substring(0, out.lastIndexOf(46)) + this.getFileExtension();
            File namesFile = new File(out);
            try {
                this.setFile(namesFile);
            }
            catch (Exception ex) {
                throw new IOException("Cannot create data file, only names file created.");
            }
            if (this.retrieveFile() == null || this.getWriter() == null) {
                throw new IOException("Cannot create data file, only names file created.");
            }
            outW = new PrintWriter(this.getWriter());
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                for (int j = 0; j < inst.numAttributes(); ++j) {
                    if (j == structure.classIndex()) continue;
                    if (inst.isMissing(j)) {
                        outW.write("?,");
                        continue;
                    }
                    if (structure.attribute(j).isNominal() || structure.attribute(j).isString()) {
                        outW.write(structure.attribute(j).value((int)inst.value(j)) + ",");
                        continue;
                    }
                    outW.write("" + inst.value(j) + ",");
                }
                if (inst.isMissing(structure.classIndex())) {
                    outW.write("?");
                } else {
                    outW.write(structure.attribute(structure.classIndex()).value((int)inst.value(structure.classIndex())));
                }
                outW.write("\n");
                ++this.m_incrementalCounter;
                if (this.m_incrementalCounter > 100) {
                    this.m_incrementalCounter = 0;
                    outW.flush();
                }
            } else {
                if (outW != null) {
                    outW.flush();
                    outW.close();
                }
                this.setFileExtension(".names");
                this.m_incrementalCounter = 0;
                this.resetStructure();
                outW = null;
                this.resetWriter();
            }
        }
    }

    @Override
    public void writeBatch() throws IOException {
        int i;
        Instances instances = this.getInstances();
        if (instances == null) {
            throw new IOException("No instances to save");
        }
        if (instances.classIndex() == -1) {
            instances.setClassIndex(instances.numAttributes() - 1);
            System.err.println("No class specified. Last attribute is used as class attribute.");
        }
        if (instances.attribute(instances.classIndex()).isNumeric()) {
            throw new IOException("To save in C4.5 format the class attribute cannot be numeric.");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        if (this.retrieveFile() == null || this.getWriter() == null) {
            throw new IOException("C4.5 format requires two files. Therefore no output to standard out can be generated.\nPlease specifiy output files using the -o option.");
        }
        this.setWriteMode(0);
        this.setFileExtension(".names");
        PrintWriter outW = new PrintWriter(this.getWriter());
        for (i = 0; i < instances.attribute(instances.classIndex()).numValues(); ++i) {
            outW.write(instances.attribute(instances.classIndex()).value(i));
            if (i < instances.attribute(instances.classIndex()).numValues() - 1) {
                outW.write(",");
                continue;
            }
            outW.write(".\n");
        }
        for (i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex()) continue;
            outW.write(instances.attribute(i).name() + ": ");
            if (instances.attribute(i).isNumeric() || instances.attribute(i).isDate()) {
                outW.write("continuous.\n");
                continue;
            }
            Attribute temp = instances.attribute(i);
            for (int j = 0; j < temp.numValues(); ++j) {
                outW.write(temp.value(j));
                if (j < temp.numValues() - 1) {
                    outW.write(",");
                    continue;
                }
                outW.write(".\n");
            }
        }
        outW.flush();
        outW.close();
        String out = this.retrieveFile().getAbsolutePath();
        this.setFileExtension(".data");
        out = out.substring(0, out.lastIndexOf(46)) + this.getFileExtension();
        File namesFile = new File(out);
        try {
            this.setFile(namesFile);
        }
        catch (Exception ex) {
            throw new IOException("Cannot create data file, only names file created (Reason: " + ex.toString() + ").");
        }
        if (this.retrieveFile() == null || this.getWriter() == null) {
            throw new IOException("Cannot create data file, only names file created.");
        }
        outW = new PrintWriter(this.getWriter());
        for (int i2 = 0; i2 < instances.numInstances(); ++i2) {
            Instance temp = instances.instance(i2);
            for (int j = 0; j < temp.numAttributes(); ++j) {
                if (j == instances.classIndex()) continue;
                if (temp.isMissing(j)) {
                    outW.write("?,");
                    continue;
                }
                if (instances.attribute(j).isNominal() || instances.attribute(j).isString()) {
                    outW.write(instances.attribute(j).value((int)temp.value(j)) + ",");
                    continue;
                }
                outW.write("" + temp.value(j) + ",");
            }
            if (temp.isMissing(instances.classIndex())) {
                outW.write("?");
            } else {
                outW.write(instances.attribute(instances.classIndex()).value((int)temp.value(instances.classIndex())));
            }
            outW.write("\n");
        }
        outW.flush();
        outW.close();
        this.setFileExtension(".names");
        this.setWriteMode(1);
        outW = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        result.addElement(new Option("The class index", "c", 1, "-c <the class index>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String outputString = Utils.getOption('o', options);
        String inputString = Utils.getOption('i', options);
        String indexString = Utils.getOption('c', options);
        ArffLoader loader = new ArffLoader();
        this.resetOptions();
        int index = -1;
        if (indexString.length() != 0) {
            index = indexString.equals("first") ? 0 : (indexString.equals("last") ? -1 : Integer.parseInt(indexString));
        }
        if (inputString.length() != 0) {
            try {
                File input = new File(inputString);
                loader.setFile(input);
                Instances inst = loader.getDataSet();
                if (index == -1) {
                    inst.setClassIndex(inst.numAttributes() - 1);
                } else {
                    inst.setClassIndex(index);
                }
                this.setInstances(inst);
            }
            catch (Exception ex) {
                throw new IOException("No data set loaded. Data set has to be arff format (Reason: " + ex.toString() + ").");
            }
        } else {
            throw new IOException("No data set to save.");
        }
        if (outputString.length() != 0) {
            if (!outputString.endsWith(this.getFileExtension())) {
                outputString = outputString.lastIndexOf(46) != -1 ? outputString.substring(0, outputString.lastIndexOf(46)) + this.getFileExtension() : outputString + this.getFileExtension();
            }
            try {
                File output = new File(outputString);
                this.setFile(output);
            }
            catch (Exception ex) {
                throw new IOException("Cannot create output file.");
            }
        }
        if (index == -1) {
            index = this.getInstances().numAttributes() - 1;
        }
        this.getInstances().setClassIndex(index);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[10];
        int current = 0;
        if (this.retrieveFile() != null) {
            options[current++] = "-o";
            options[current++] = "" + this.retrieveFile();
        } else {
            options[current++] = "-o";
            options[current++] = "";
        }
        if (this.getInstances() != null) {
            options[current++] = "-i";
            options[current++] = "" + this.getInstances().relationName();
            options[current++] = "-c";
            options[current++] = "" + this.getInstances().classIndex();
        } else {
            options[current++] = "-i";
            options[current++] = "";
            options[current++] = "-c";
            options[current++] = "";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        C45Saver.runFileSaver(new C45Saver(), args);
    }
}

