/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Version;

public class Environment
implements RevisionHandler {
    private static Environment m_systemWide = new Environment();
    private Map<String, String> m_envVars = new TreeMap<String, String>();

    public Environment() {
        Map<String, String> env = System.getenv();
        Set<String> keys = env.keySet();
        for (String kv : keys) {
            String value = env.get(kv);
            this.m_envVars.put(kv, value);
        }
        Properties jvmProps = System.getProperties();
        Enumeration<?> pKeys = jvmProps.propertyNames();
        while (pKeys.hasMoreElements()) {
            String kv = (String)pKeys.nextElement();
            String value = jvmProps.getProperty(kv);
            this.m_envVars.put(kv, value);
        }
        this.m_envVars.put("weka.version", Version.VERSION);
    }

    public static Environment getSystemWide() {
        return m_systemWide;
    }

    public static boolean containsEnvVariables(String source) {
        return source.indexOf("${") >= 0;
    }

    public String substitute(String source) throws Exception {
        int endIndex;
        int index = source.indexOf("${");
        while (index >= 0 && (endIndex = source.indexOf(125)) >= 0 && endIndex > (index += 2) + 1) {
            String key = source.substring(index, endIndex);
            String replace = this.m_envVars.get(key);
            if (replace == null) {
                throw new Exception("[Environment] Variable " + key + " doesn't seem to be set.");
            }
            String toReplace = "${" + key + "}";
            source = source.replace(toReplace, replace);
            index = source.indexOf("${");
        }
        return source;
    }

    public void addVariable(String key, String value) {
        this.m_envVars.put(key, value);
    }

    public void addVariableSystemWide(String key, String value) {
        this.addVariable(key, value);
        if (this != Environment.getSystemWide()) {
            Environment.getSystemWide().addVariableSystemWide(key, value);
        }
        System.setProperty(key, value);
    }

    public void removeVariable(String key) {
        this.m_envVars.remove(key);
    }

    public Set<String> getVariableNames() {
        return this.m_envVars.keySet();
    }

    public String getVariableValue(String key) {
        return this.m_envVars.get(key);
    }

    public static void main(String[] args) {
        Environment t = new Environment();
        if (args.length == 0) {
            System.err.println("Usage: java weka.core.Environment <string> <string> ...");
        } else {
            try {
                for (int i = 0; i < args.length; ++i) {
                    String newS = t.substitute(args[i]);
                    System.out.println("Original string:\n" + args[i] + "\n\nNew string:\n" + newS);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

