% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD_Cubes.R
\name{DSD_Cubes}
\alias{DSD_Cubes}
\title{Static Cubes Data Stream Generator}
\usage{
DSD_Cubes(k = 2, d = 2, center, size, p, noise = 0, noise_range)
}
\arguments{
\item{k}{Determines the number of clusters.}

\item{d}{Determines the number of dimensions.}

\item{center}{A matrix of means for each dimension of each cluster.}

\item{size}{A \code{k} times \code{d} matrix with the cube dimensions.}

\item{p}{A vector of probabilities that determines the likelihood of
generated a data point from a particular cluster.}

\item{noise}{Noise probability between 0 and 1.  Noise is uniformly
distributed within noise range (see below).}

\item{noise_range}{A matrix with d rows and 2 columns. The first column
contains the minimum values and the second column contains the maximum
values for noise.}
}
\value{
Returns a \code{DSD_Cubes} object (subclass of \link{DSD_R}, \link{DSD}).
}
\description{
A data stream generator that produces a data stream with static (hyper)
cubes filled uniformly with data points.
}
\examples{
# create data stream with three clusters in 3D
stream <- DSD_Cubes(k = 3, d = 3, noise = 0.05)

get_points(stream, n = 5)

plot(stream)
}
\seealso{
Other DSD: 
\code{\link{DSD}()},
\code{\link{DSD_BarsAndGaussians}()},
\code{\link{DSD_Benchmark}()},
\code{\link{DSD_Gaussians}()},
\code{\link{DSD_MG}()},
\code{\link{DSD_Memory}()},
\code{\link{DSD_Mixture}()},
\code{\link{DSD_NULL}()},
\code{\link{DSD_ReadDB}()},
\code{\link{DSD_ReadStream}()},
\code{\link{DSD_Target}()},
\code{\link{DSD_UniformNoise}()},
\code{\link{DSD_mlbenchData}()},
\code{\link{DSD_mlbenchGenerator}()},
\code{\link{DSF}()},
\code{\link{animate_data}()},
\code{\link{close_stream}()},
\code{\link{get_points}()},
\code{\link{plot.DSD}()},
\code{\link{reset_stream}()}
}
\author{
Michael Hahsler
}
\concept{DSD}
