% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_DBSCAN.R
\name{DSC_DBSCAN}
\alias{DSC_DBSCAN}
\alias{DBSCAN}
\alias{dbscan}
\title{DBSCAN Macro-clusterer}
\usage{
DSC_DBSCAN(
  formula = NULL,
  eps,
  MinPts = 5,
  weighted = TRUE,
  description = NULL
)
}
\arguments{
\item{formula}{\code{NULL} to use all features in the stream or a model \link{formula} of the form \code{~ X1 + X2}
to specify the features used for clustering. Only \code{.}, \code{+} and \code{-} are currently
supported in the formula.}

\item{eps}{radius of the eps-neighborhood.}

\item{MinPts}{minimum number of points required in the eps-neighborhood.}

\item{weighted}{logical indicating if a weighted version of DBSCAN should be
used.}

\item{description}{optional character string to describe the clustering
method.}
}
\value{
An object of class \code{DSC_DBSCAN} (a subclass of \link{DSC},
\link{DSC_R}, \link{DSC_Macro}).
}
\description{
Macro Clusterer.
Implements the DBSCAN algorithm for reclustering micro-clusterings.
}
\details{
DBSCAN is a weighted extended version of the implementation in \pkg{fpc}
where each micro-cluster center considered a pseudo point. For weighting we
use in the MinPts comparison the sum of weights of the micro-cluster instead
of the number.

DBSCAN first finds core points based on the number of other points in its
eps-neighborhood. Then core points are joined into clusters using
reachability (overlapping eps-neighborhoods).

\code{\link[=update]{update()}} and \code{\link[=recluster]{recluster()}} invisibly return the assignment of the data points to clusters.

\strong{Note} that this clustering cannot be updated iteratively and every time it is
used for (re)clustering, the old clustering is deleted.
}
\examples{
# 3 clusters with 5\% noise
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

# Use a moving window for "micro-clusters and recluster with DBSCAN (macro-clusters)
cl <- DSC_TwoStage(
  micro = DSC_Window(horizon = 100),
  macro = DSC_DBSCAN(eps = .05)
)

update(cl, stream, 500)
cl

plot(cl, stream)
}
\references{
Martin Ester, Hans-Peter Kriegel, Joerg Sander, Xiaowei Xu
(1996). A density-based algorithm for discovering clusters in large spatial
databases with noise. In Evangelos Simoudis, Jiawei Han, Usama M. Fayyad.
\emph{Proceedings of the Second International Conference on Knowledge
Discovery and Data Mining (KDD-96).} AAAI Press. pp. 226-231.
}
\seealso{
Other DSC_Macro: 
\code{\link{DSC_EA}()},
\code{\link{DSC_Hierarchical}()},
\code{\link{DSC_Kmeans}()},
\code{\link{DSC_Macro}()},
\code{\link{DSC_Reachability}()}
}
\author{
Michael Hahsler
}
\concept{DSC_Macro}
