% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fscRun.R
\name{fscRun}
\alias{fscRun}
\alias{fscCleanup}
\alias{fscTutorial}
\title{Run fastsimcoal}
\usage{
fscRun(
  p,
  num.sims = 1,
  dna.to.snp = FALSE,
  max.snps = 0,
  sfs.type = c("maf", "daf"),
  nonpar.boot = NULL,
  all.sites = TRUE,
  inf.sites = FALSE,
  no.arl.output = FALSE,
  num.loops = 20,
  min.num.loops = 20,
  brentol = 0.01,
  trees = FALSE,
  num.cores = 1,
  seed = NULL,
  quiet = TRUE,
  exec = "fsc26"
)

fscCleanup(label, folder = ".")

fscTutorial()
}
\arguments{
\item{p}{list of fastsimcoal input parameters and output produced by 
\link{fscWrite}.}

\item{num.sims}{number of simulation replicates to run.}

\item{dna.to.snp}{convert DNA sequences to numerical SNPs?}

\item{max.snps}{maximum number of SNPs to retain.}

\item{sfs.type}{type of site frequency spectrum to compute for each 
population sample: `daf` = derived allele frequency (unfolded), 
`maf` = minor allele frequency (folded).}

\item{nonpar.boot}{number of bootstraps to perform on polymorphic sites to
extract SFS.}

\item{all.sites}{retain all sites? If \code{FALSE}, only polymorphic DNA 
sites will be returned. This includes SNP blocks as they are simulated as 
DNA sequences.}

\item{inf.sites}{use infinite sites model? If \code{TRUE}, all mutations are 
retained in the output, thus the number of sites for SNPs or DNA sequences 
will potentially be greater than what was requested.}

\item{no.arl.output}{do not output arlequin files.}

\item{num.loops}{number of loops (ECM cycles) to be performed when 
estimating parameters from SFS. Default is 20.}

\item{min.num.loops}{number of loops (ECM cycles) for which the 
likelihood is computed on both monomorphic and polymorphic sites. Default 
is 20.}

\item{brentol}{Tolerance level for Brent optimization.
Smaller value imply more precise estimations, but require more 
computation time. Default = 0.01. Value is restricted between 
1e-5 and 1e-1.}

\item{trees}{output NEXUS formatted coalescent trees for all replicates?}

\item{num.cores}{number of cores to use. If set to \code{NULL}, the value
will be what is reported by \code{\link[parallel]{detectCores} - 1}.}

\item{seed}{random number seed for simulation.}

\item{quiet}{logical indicating if fastsimcoal2 should be run in quiet mode.}

\item{exec}{name of fastsimcoal executable.}

\item{label}{character string of file run labels prefixes.}

\item{folder}{character string giving the root working folder where
input files and output resides}
}
\value{
\describe{
 \item{fscRun}{Runs the \code{fastsimcoal2} simulation and returns a
   list containing run parameters and a data frame used by 
   \code{\link{fscRead}} to parse the genotypes generated (if 
   Arlequin-formatted output was requested).}
 \item{fscCleanup}{Deletes all files associated with the simulation 
   identified by \code{label}.}
 }
}
\description{
Run a fastsimcoal simulation.
}
\note{
\code{fastsimcoal2} is not included with `strataG` and must be
  downloaded separately. Additionally, it must be installed such that it can
  be run from the command line in the current working directory. 
  The function \code{fscTutorial()} will open a detailed tutorial on the 
  interface in your web browser.
}
\examples{
\dontrun{
#' # three demes with optional names
demes <- fscSettingsDemes(
  Large = fscDeme(10000, 10), 
  Small = fscDeme(2500, 10),
  Medium = fscDeme(5000, 3, 1500)
)

# four historic events
events <- fscSettingsEvents(
  fscEvent(event.time = 2000, source = 1, sink = 2, prop.migrants = 0.05),
  fscEvent(2980, 1, 1, 0, 0.04),
  fscEvent(3000, 1, 0),
  fscEvent(15000, 0, 2, new.size = 3)
 )
 
# four genetic blocks of different types on three chromosomes.  
genetics <- fscSettingsGenetics(
  fscBlock_snp(10, 1e-6, chromosome = 1),
  fscBlock_dna(10, 1e-5, chromosome = 1),
  fscBlock_microsat(3, 1e-4, chromosome = 2),
  fscBlock_standard(5, 1e-3, chromosome = 3)
)

params <- fscWrite(demes = demes, events = events, genetics = genetics)

# runs 100 replicates, converting all DNA sequences to 0/1 SNPs
# will also output the MAF site frequency spectra (SFS) for all SNP loci.
params <- fscRun(params, num.sim = 100, dna.to.snp = TRUE, num.cores = 3)
}

}
\references{
Excoffier, L. and Foll, M (2011) fastsimcoal: a continuous-time 
  coalescent simulator of genomic diversity under arbitrarily complex 
  evolutionary scenarios Bioinformatics 27: 1332-1334.\cr
  Excoffier, L., Dupanloup, I., Huerta-Sánchez, E., Sousa, V.C., 
  and M. Foll (2013) Robust demographic inference from genomic and SNP data. 
  PLOS Genetics, 9(10):e1003905. \cr
  \url{http://cmpg.unibe.ch/software/fastsimcoal2/}
}
\seealso{
\code{\link{fsc.input}}, \code{\link{fscWrite}}, 
 \code{\link{fscRead}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
