% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fscRead.R
\name{fscRead}
\alias{fscRead}
\alias{fscReadArp}
\alias{fscReadParamEst}
\alias{fscReadSFS}
\title{Read fastsimcoal output}
\usage{
fscReadArp(
  p,
  sim = c(1, 1),
  marker = c("all", "snp", "microsat", "dna", "standard"),
  chrom = NULL,
  sep.chrom = FALSE,
  drop.mono = FALSE,
  as.genotypes = TRUE,
  one.col = FALSE,
  sep = "/",
  coded.snps = FALSE
)

fscReadParamEst(p)

fscReadSFS(p, sim = 1)
}
\arguments{
\item{p}{list of fastsimcoal input parameters.}

\item{sim}{one or two-element numberic vector giving the number of the
simulation replicate (and sub-replicate) to read. For example, \code{sim =
c(3, 5)} will attempt to read "<label>_3_5.arp".}

\item{marker}{type of marker to return.}

\item{chrom}{numerical vector giving chromosomes to return. If \code{NULL}
all chromosomes are returned.}

\item{sep.chrom}{return a list of separate chromosomes?}

\item{drop.mono}{return only polymorphic loci?}

\item{as.genotypes}{return data as genotypes? If \code{FALSE}, original
haploid data is returned. If \code{TRUE}, individuals are created by
combining sequential haplotypes based on the ploidy used to run the
simulation.}

\item{one.col}{return genotypes with one column per locus? If \code{FALSE},
alleles are split into separate columns and designated as ".1", ".2", etc.
for each locus.}

\item{sep}{character to use to separate alleles if \code{one.col = TRUE}.}

\item{coded.snps}{return diploid SNPs coded as 0 (major allele homozygote), 1
(heterozygote), or 2 (minor allele homozygote). If this is \code{TRUE} and
\code{marker = "snp"} (or only SNPs are present) and the data is diploid,
genotypes will be returned with one column per locus.}
}
\value{
\describe{
 \item{fscReadArp}{Reads and parses Arlequin-formatted .arp output files 
   created by \code{fastsimcoal2}. Returns a data frame of genotypes, with 
   individuals created by combining haplotypes based on the stored value of
   ploidy specified when the simulation was run.}
 \item{fscReadParamEst}{Reads and parses files output from a 
   \code{fastsimcoal2} run conducted for parameter estimation. Returns a list 
   of data frames and vectors containing the data from each file.}
 \item{fscReadSFS}{Reads site frequency spectra generated from 
   \code{fastsimcoal2}. Returns a list of the marginal and joint SFS, the 
   polymorphic sites, and the estimated maximum likelihood of the SFS."}
 }
}
\description{
Read arlequin formatted output or parameter estimation files 
  generated by fastsimcoal
}
\note{
\code{fastsimcoal2} is not included with `strataG` and must be
  downloaded separately. Additionally, it must be installed such that it can
  be run from the command line in the current working directory. 
  The function \code{fscTutorial()} will open a detailed tutorial on the 
  interface in your web browser.
}
\examples{
\dontrun{
#' # three demes with optional names
demes <- fscSettingsDemes(
  Large = fscDeme(10000, 10), 
  Small = fscDeme(2500, 10),
  Medium = fscDeme(5000, 3, 1500)
)

# four historic events
events <- fscSettingsEvents(
  fscEvent(event.time = 2000, source = 1, sink = 2, prop.migrants = 0.05),
  fscEvent(2980, 1, 1, 0, 0.04),
  fscEvent(3000, 1, 0),
  fscEvent(15000, 0, 2, new.size = 3)
 )
 
# four genetic blocks of different types on three chromosomes.  
genetics <- fscSettingsGenetics(
  fscBlock_snp(10, 1e-6, chromosome = 1),
  fscBlock_dna(10, 1e-5, chromosome = 1),
  fscBlock_microsat(3, 1e-4, chromosome = 2),
  fscBlock_standard(5, 1e-3, chromosome = 3)
)

params <- fscWrite(demes = demes, events = events, genetics = genetics)

# runs 100 replicates, converting all DNA sequences to 0/1 SNPs
# will also output the MAF site frequency spectra (SFS) for all SNP loci.
params <- fscRun(params, num.sim = 100, dna.to.snp = TRUE, num.cores = 3)

# extracting only microsattelite loci from simulation replicate 1
msats <- fscReadArp(params, marker = "microsat")

# read SNPs from simulation replicate 5 with genotypes coded as 0/1
snp.5 <- fscReadArp(params, sim = 1, marker = "snp", coded.snps = TRUE

# read SFS for simulation 20
sfs.20 <- fscReadSFS(params, sim = 20)
}

}
\references{
Excoffier, L. and Foll, M (2011) fastsimcoal: a continuous-time 
  coalescent simulator of genomic diversity under arbitrarily complex 
  evolutionary scenarios Bioinformatics 27: 1332-1334.\cr
  Excoffier, L., Dupanloup, I., Huerta-Sánchez, E., Sousa, V.C., 
  and M. Foll (2013) Robust demographic inference from genomic and SNP data. 
  PLOS Genetics, 9(10):e1003905. \cr
  \url{http://cmpg.unibe.ch/software/fastsimcoal2/}
}
\seealso{
\code{\link{fsc.input}}, \code{\link{fscWrite}}, 
 \code{\link{fscRun}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
