% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validIupacCodes.R
\name{validIupacCodes}
\alias{validIupacCodes}
\title{Valid IUPAC Codes}
\usage{
validIupacCodes(bases)
}
\arguments{
\item{bases}{character vector of nucleotides or IUPAC codes to be checked.}
}
\value{
character vector of valid IUPAC codes for \code{bases}.
}
\description{
Get all possible valid IUPAC ambiguity codes for a set 
  of nucleotide bases and ambiguity codes.
}
\examples{
validIupacCodes(c("c", "t", "c", "c"))

validIupacCodes(c("c", "y", "c", "c"))

validIupacCodes(c("a", "g", "t", "a"))

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
