% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleotideDiversity.R
\name{nucleotideDiversity}
\alias{nucleotideDiversity}
\title{Nucleotide Diversity}
\usage{
nucleotideDiversity(x, bases = c("a", "c", "g", "t"), simplify = TRUE)
}
\arguments{
\item{x}{a set of sequences or a \linkS4class{gtypes} object with sequences.}

\item{bases}{nucleotides to consider when calculating diversity.}

\item{simplify}{if \code{TRUE} and only one loci exists, return a vector, 
otherwise, a list of vectors with one element per locus will be returned.}
}
\value{
Nucleotide diversity by site.
}
\description{
Calculate nucleotide diversity for set of haplotypes.
}
\examples{
data(dolph.strata)
data(dolph.seqs)
strata <- dolph.strata$fine
names(strata) <- dolph.strata$ids
dloop <- sequence2gtypes(dolph.seqs, strata, seq.names = "dLoop")

nucleotideDiversity(dloop)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
